/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.tile;

import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.base.util.info.EnergyPacketInfo;
import ic2.core.block.base.util.info.SinkTierInfo;
import ic2.core.block.base.util.info.SourceTierInfo;
import ic2.core.block.base.util.info.misc.IEmitterTile;
import ic2.core.block.wiring.container.ContainerAdjustableTransformer;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityAdjustableTransformer
extends TileEntityBlock
implements IMultiEnergySource,
IEmitterTile,
IEnergySink,
IEUStorage,
INetworkClientTileEventListener,
IHasGui {
    @NetworkField(index=3)
    public int energy;
    public int sinkTier = 6;
    @NetworkField(index=4, compression=NetworkField.BitLevel.Bit8)
    public int packetCount = 1;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit24)
    public int energyPacket = 32;
    @NetworkField(index=6)
    public int maxEnergy = 256;
    public boolean addedToEnergyNet = false;

    public TileEntityAdjustableTransformer() {
        this.addGuiFields("energy", "maxEnergy", "packetCount", "energyPacket");
        this.addInfos(new EnergyInfo(this), new SinkTierInfo(this), new SourceTierInfo(this), new EnergyPacketInfo(this));
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    @Override
    public int getOutput() {
        return this.energyPacket;
    }

    @Override
    public int getStoredEU() {
        return this.energy;
    }

    @Override
    public int getMaxEU() {
        return this.maxEnergy;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.transformerAdjustable;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74762_e("Energy");
        this.packetCount = nbt.func_74762_e("Packet");
        this.energyPacket = nbt.func_74762_e("PacketEnergy");
        this.maxEnergy = nbt.func_74762_e("MaxEnergy");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Energy", this.energy);
        nbt.func_74768_a("Packet", this.packetCount);
        nbt.func_74768_a("PacketEnergy", this.energyPacket);
        nbt.func_74768_a("MaxEnergy", this.maxEnergy);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.addedToEnergyNet) {
            this.addedToEnergyNet = true;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public double getOfferedEnergy() {
        if (this.energy < this.energyPacket) {
            return 0.0;
        }
        return this.energyPacket;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy = (int)((double)this.energy - amount);
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public int getSourceTier() {
        return this.sinkTier;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getFacing() != side;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.getFacing() == side;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int getSinkTier() {
        return this.sinkTier;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount > EnergyNet.instance.getPowerFromTier(this.sinkTier) || amount <= 0.0) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
        return re;
    }

    @Override
    public boolean sendMultipleEnergyPackets() {
        return this.packetCount > 1;
    }

    @Override
    public int getMultipleEnergyPacketAmount() {
        return this.packetCount;
    }

    @Override
    public void setFacing(EnumFacing face) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(face);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0) {
            this.packetCount += value;
            if (this.packetCount > 32) {
                this.packetCount = 32;
            } else if (this.packetCount < 1) {
                this.packetCount = 1;
            }
            this.getNetwork().updateTileGuiField(this, "packetCount");
        } else if (event == 1) {
            this.energyPacket += value;
            if (this.energyPacket > Short.MAX_VALUE) {
                this.energyPacket = Short.MAX_VALUE;
            } else if (this.energyPacket < 1) {
                this.energyPacket = 1;
            }
            this.maxEnergy = this.energyPacket * 32;
            this.getNetwork().updateTileGuiField(this, "energyPacket");
            this.getNetwork().updateTileGuiField(this, "maxEnergy");
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerAdjustableTransformer(this, player.field_71071_by);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }
}

