/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.base.tile.TileEntityElectricBlock;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IconButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyStorageComp
extends GuiComponent {
    public static final ItemStack red = new ItemStack(Items.field_151137_ax);
    byte lastMode;
    TileEntityElectricBlock block;
    boolean baubles;

    public EnergyStorageComp(TileEntityElectricBlock tile) {
        super(Ic2GuiComp.nullBox);
        this.block = tile;
        this.baubles = Loader.isModLoaded((String)"baubles");
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiTick, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.BackgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        gui.drawString(Ic2GuiLang.energyStorageCharge, 79, 25, 0x404040);
        int eu = this.block.getStoredEU();
        int max = this.block.getMaxEU();
        if (eu > max) {
            eu = max;
        }
        gui.drawString("" + eu, 110, 35, 0x404040);
        gui.drawString("/" + max, 107, 45, 0x404040);
        gui.drawString(Ic2GuiLang.energyStorageOutput.getLocalizedFormatted(this.block.output), 85, 60, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        int eu = this.block.getStoredEU();
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        if (eu > 0) {
            int lvl;
            float per = (float)eu / (float)this.block.getMaxEU();
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 24.0f)) > 0) {
                gui.func_73729_b(x + 79, y + 34, 176, 14, lvl, 16);
            }
        }
        if (this.baubles) {
            gui.func_73729_b(x - 44, y, 176, 31, 48, 85);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        this.lastMode = this.block.redstoneMode;
        gui.registerButton(new IconButton(0, gui.getXOffset() + 152, gui.getYOffset() + 4, 20, 20).setItemStack(red).addText(this.block.getRedstoneMode()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        if (this.lastMode != this.block.redstoneMode) {
            this.lastMode = this.block.redstoneMode;
            gui.getCastedButton(0, IconButton.class).clearText().addText(this.block.getRedstoneMode());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        this.block.getNetwork().initiateClientTileEntityEvent(this.block, 0);
    }
}

