/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.uranTypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.item.ItemStack;

public class StandartUranium
extends UranBaseType {
    public StandartUranium() {
        this.loadDefaults();
    }

    @Override
    public int getMaxDurability() {
        return 10000;
    }

    @Override
    public float getEUPerPulse() {
        return 1.0f;
    }

    @Override
    public int getPulsesPerTick() {
        return 1;
    }

    @Override
    public int getPulsesForConnection() {
        return 1;
    }

    @Override
    public float getHeatModifier() {
        return 1.0f;
    }

    @Override
    public float getExplosionEffectModifier() {
        return 2.0f;
    }

    @Override
    public ItemStack getUraniumIngot() {
        return Ic2Items.uraniumIngot.func_77946_l();
    }

    @Override
    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2Items.reactorUraniumRodSingle.func_77946_l();
            }
            case DualRod: {
                return Ic2Items.reactorUraniumRodDual.func_77946_l();
            }
            case QuadRod: {
                return Ic2Items.reactorUraniumRodQuad.func_77946_l();
            }
            case NearDepletedRod: {
                return Ic2Items.reactorNearDepletedUraniumRod.func_77946_l();
            }
            case IsotopicRod: {
                return Ic2Items.reactorUraniumIsotopicRod.func_77946_l();
            }
            case ReEnrichedRod: {
                return Ic2Items.reactorReEnrichedUraniumRod.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage(this.getRodType(IUranium.RodType.IsotopicRod), this.getMaxDurability() - 1);
    }

    @Override
    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 0;
            }
            case DualRod: {
                return 1;
            }
            case QuadRod: {
                return 2;
            }
            case IsotopicRod: {
                return 36;
            }
        }
        return 0;
    }

    @Override
    public int getRow() {
        return 0;
    }

    @Override
    public LocaleComp getName(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2ItemLang.uranRodSingle;
            }
            case DualRod: {
                return Ic2ItemLang.uranRodDouble;
            }
            case QuadRod: {
                return Ic2ItemLang.uranRodQuad;
            }
            case NearDepletedRod: {
                return Ic2ItemLang.uranRodNearDeplete;
            }
            case IsotopicRod: {
                return Ic2ItemLang.uranRodIsotopic;
            }
            case ReEnrichedRod: {
                return Ic2ItemLang.uranRodReEnriched;
            }
        }
        return Ic2Lang.nullKey;
    }

    @Override
    public boolean isReEnrichedUran() {
        return false;
    }

    @Override
    public Color getReEnrichedColor() {
        return Color.GREEN;
    }

    @Override
    public ItemStack getIngridient() {
        return null;
    }

    @Override
    public int getIngrientPoints() {
        return 0;
    }

    @Override
    public int getIngridientCost() {
        return 0;
    }
}

