/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.event.FoamEvent;
import ic2.api.classic.item.IFoamProvider;
import ic2.api.item.ICustomDamageItem;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemToolSprayer
extends ItemIC2
implements ICustomDamageItem,
ICustomItemCameraTransform {
    public ItemToolSprayer() {
        this.func_77656_e(1602);
        this.func_77625_d(1);
        this.setUnlocalizedName(Ic2ItemLang.cfSprayer);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 16;
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
        items.add((Object)new ItemStack((Item)this, 1, 0));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        int foamCount;
        if (IC2.platform.isRendering()) {
            return EnumActionResult.PASS;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        FoamEvent.Check checkEvent = new FoamEvent.Check(worldIn, pos);
        MinecraftForge.EVENT_BUS.post((Event)checkEvent);
        boolean recheck = false;
        if (!state.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && (checkEvent.isCanceled() || !checkEvent.hasCustomTarget() && !Ic2States.constructionFoam.func_177230_c().func_176196_c(worldIn, pos))) {
            recheck = true;
            pos = pos.func_177972_a(facing);
            state = worldIn.func_180495_p(pos);
        }
        if (recheck) {
            checkEvent = new FoamEvent.Check(worldIn, pos);
            MinecraftForge.EVENT_BUS.post((Event)checkEvent);
            if (!state.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && (checkEvent.isCanceled() || !checkEvent.hasCustomTarget() && !Ic2States.constructionFoam.func_177230_c().func_176196_c(worldIn, pos))) {
                return EnumActionResult.FAIL;
            }
        }
        if ((foamCount = this.getSprayMass(stack = player.func_184586_b(hand))) <= 0) {
            return EnumActionResult.FAIL;
        }
        ItemStack provider = ItemToolSprayer.getFoamProvider(player, foamCount);
        if (provider.func_190926_b() && this.getFoamAmount(stack) < foamCount) {
            return EnumActionResult.FAIL;
        }
        if (checkEvent.isCanceled()) {
            return EnumActionResult.FAIL;
        }
        FoamEvent.FoamResult result = checkEvent.getFoamResult();
        LinkedList<BlockPos> check = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> place = new LinkedHashSet<BlockPos>();
        place.add(pos);
        --foamCount;
        RotationList rotations = this.calculateDirectionsFromPlayer(player);
        this.addAdjacentSpaceOnList(pos, check, place, rotations, result != FoamEvent.FoamResult.Any);
        while (check.size() > 0 && foamCount > 0) {
            BlockPos posCheck = check.remove();
            checkEvent = new FoamEvent.Check(worldIn, posCheck);
            MinecraftForge.EVENT_BUS.post((Event)checkEvent);
            if (checkEvent.isCanceled() || result != FoamEvent.FoamResult.Any && result != checkEvent.getFoamResult() || !checkEvent.hasCustomTarget() && !Ic2States.constructionFoam.func_177230_c().func_176196_c(worldIn, posCheck) || !place.add(posCheck)) continue;
            this.addAdjacentSpaceOnList(posCheck, check, place, rotations, checkEvent.hasCustomTarget());
            --foamCount;
        }
        for (BlockPos placePos : place) {
            FoamEvent.Place foamPlace = new FoamEvent.Place(worldIn, placePos);
            MinecraftForge.EVENT_BUS.post((Event)foamPlace);
            if (foamPlace.isCanceled() && !foamPlace.hasFoamPlaceRequest()) continue;
            worldIn.func_175656_a(placePos, Ic2States.constructionFoam);
        }
        if (place.size() > 0) {
            if (!provider.func_190926_b()) {
                ((IFoamProvider)provider.func_77973_b()).useFoam(player, provider, place.size());
            } else {
                this.useFoam(stack, player, place.size());
            }
            this.onFoam(stack, player, place.size());
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void addAdjacentSpaceOnList(BlockPos pos, List<BlockPos> list, Set<BlockPos> alreadyDone, RotationList rotations, boolean ignoreDirections) {
        if (ignoreDirections) {
            rotations = RotationList.ALL;
        }
        for (EnumFacing facing : rotations.getRandomIterator()) {
            BlockPos other = pos.func_177972_a(facing);
            if (alreadyDone.contains(other)) continue;
            list.add(other);
        }
    }

    public static ItemStack getFoamProvider(EntityPlayer player, int amount) {
        IBaublesPlugin plugin;
        IFoamProvider provider;
        ItemStack stack;
        int i;
        ItemStack result = ItemStack.field_190927_a;
        for (i = 0; i < 4; ++i) {
            stack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (!(stack.func_77973_b() instanceof IFoamProvider) || !(provider = (IFoamProvider)stack.func_77973_b()).canProvideFoam(player, stack, amount, IFoamProvider.ProviderSlot.Armor)) continue;
            result = stack;
            break;
        }
        if (result.func_190926_b() && (plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class)) != null) {
            result = plugin.getFoamProvider(player, amount);
        }
        if (result.func_190926_b()) {
            IFoamProvider provider2;
            ItemStack stack2;
            for (i = 0; i < 9; ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof IFoamProvider) || !(provider = (IFoamProvider)stack.func_77973_b()).canProvideFoam(player, stack, amount, IFoamProvider.ProviderSlot.Hotbar)) continue;
                result = stack;
                break;
            }
            if (result.func_190926_b() && (stack2 = player.func_184592_cb()).func_77973_b() instanceof IFoamProvider && (provider2 = (IFoamProvider)stack2.func_77973_b()).canProvideFoam(player, stack2, amount, IFoamProvider.ProviderSlot.OffHand)) {
                result = stack2;
            }
        }
        return result;
    }

    public int getFoamAmount(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    public void useFoam(ItemStack stack, EntityPlayer player, int amount) {
        stack.func_77972_a(100, (EntityLivingBase)player);
    }

    public void onFoam(ItemStack stack, EntityPlayer player, int foamAmount) {
        IC2.achievements.issueStat(player, "foamSprayed", foamAmount);
    }

    public int getSprayMass(ItemStack stack) {
        return 13;
    }

    public RotationList calculateDirectionsFromPlayer(EntityPlayer player) {
        EnumSet<EnumFacing> dirs = EnumSet.allOf(EnumFacing.class);
        float yaw = player.field_70177_z % 360.0f;
        float pitch = player.field_70125_A % 360.0f;
        if (pitch >= -65.0f && pitch <= 65.0f) {
            if (yaw >= 300.0f && yaw <= 360.0f || yaw >= 0.0f && yaw <= 60.0f) {
                dirs.remove(EnumFacing.NORTH);
            }
            if (yaw >= 30.0f && yaw <= 150.0f) {
                dirs.remove(EnumFacing.EAST);
            }
            if (yaw >= 120.0f && yaw <= 240.0f) {
                dirs.remove(EnumFacing.SOUTH);
            }
            if (yaw >= 210.0f && yaw <= 330.0f) {
                dirs.remove(EnumFacing.WEST);
            }
        }
        if (pitch <= -40.0f) {
            dirs.remove(EnumFacing.DOWN);
        }
        if (pitch >= 40.0f) {
            dirs.remove(EnumFacing.UP);
        }
        return RotationList.ofFacings(dirs);
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        return stack.func_77952_i();
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return stack.func_77958_k();
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        stack.func_77964_b(damage);
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        if (src == null) {
            return stack.func_96631_a(damage, field_77697_d, null);
        }
        stack.func_77972_a(damage, src);
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

