/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.lang.components.base;

import ic2.core.platform.lang.components.base.LocaleComp;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class LocaleCompBase
extends LocaleComp {
    protected String key;
    protected String value;
    protected String category;

    public LocaleCompBase(String name) {
        this.key = name;
        this.reload();
    }

    public void setCategory(String cat) {
        this.category = cat;
    }

    @Override
    public void reload() {
        super.reload();
        this.value = this.translate(this.getUnlocalizedFully());
    }

    @Override
    public String getLocalized() {
        return this.value;
    }

    @Override
    public String getLocalizedFormatted(Object ... obj) {
        return this.addObjects(this.value, this.convertToString(obj));
    }

    @Override
    public String getUnlocalized() {
        return this.key;
    }

    @Override
    public ITextComponent createComponent() {
        return new TextComponentTranslation(this.getUnlocalizedFully(), new Object[0]);
    }

    @Override
    public ITextComponent createComponent(Object ... obj) {
        return new TextComponentTranslation(this.getUnlocalizedFully(), this.validateComponents(obj));
    }

    @Override
    public String getUnlocalizedFully() {
        return this.key;
    }

    @Override
    public void applyToExport(Map<String, Map<String, String>> export) {
        String value;
        String key = this.getUnlocalizedFully();
        if (key.equals(value = this.getLocalized())) {
            value = "";
        }
        this.getCategory(export, this.category).put(key, value);
    }
}

