/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.math;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;

public class IntCounter
implements INetworkFieldData {
    int startValue;
    int counter;

    public IntCounter() {
        this(0);
    }

    public IntCounter(int initialValue) {
        this.startValue = initialValue;
        this.counter = initialValue;
    }

    public void increase() {
        this.increase(1);
    }

    public void increase(int amount) {
        this.counter += amount;
    }

    public void decrease() {
        this.decrease(1);
    }

    public void decrease(int amount) {
        this.counter -= amount;
    }

    public void reset() {
        this.counter = this.startValue;
    }

    public int getValue() {
        return this.counter;
    }

    public int getStartValue() {
        return this.startValue;
    }

    public void setValue(int amount) {
        this.counter = amount;
    }

    public void setStartValue(int amount) {
        this.startValue = amount;
    }

    public void setIfHigher(int newValue) {
        if (newValue > this.counter) {
            this.counter = newValue;
        }
    }

    public void setIfLower(int newValue) {
        if (newValue < this.counter) {
            this.counter = newValue;
        }
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.startValue = buffer.readInt();
        this.counter = buffer.readInt();
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeInt(this.startValue);
        buffer.writeInt(this.counter);
    }
}

