/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.client.gui.GuiStructureView;
import pregenerator.impl.structure.StructureData;

public class StructureAnswerPacket
extends PregenPacket {
    byte type;
    List<StructureData> data = new ArrayList<StructureData>();

    public void setType(int type) {
        this.type = (byte)type;
    }

    public void addData(StructureData entry) {
        this.data.add(entry);
    }

    public boolean hasData() {
        return this.data.size() > 0;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.type = buffer.readByte();
        if (this.type == -1) {
            return;
        }
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            StructureData entry = new StructureData();
            entry.readFromBuffer(buffer);
            this.data.add(entry);
        }
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeByte(this.type);
        if (this.type == -1) {
            return;
        }
        buffer.writeInt(this.data.size());
        for (StructureData entry : this.data) {
            entry.writeToBuffer(buffer);
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.handleClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        if (this.type == -1) {
            GuiStructureView.INSTANCE.noDataFound();
            return;
        }
        GuiStructureView.INSTANCE.addData(this.data, this.type);
    }
}

