/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.gui;

import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.network.packets.gui.ProcessAnswerPacket;
import pregenerator.impl.processor.deleter.DeleteProcessor;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.storage.TaskStorage;

public class ManualTaskPacket
extends PregenPacket {
    int mod;

    public ManualTaskPacket() {
    }

    public ManualTaskPacket(int mod) {
        this.mod = mod;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.mod = buffer.readByte();
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeByte(this.mod);
    }

    @Override
    public void handle(final EntityPlayer player) {
        MinecraftServer server = ChunkPregenerator.getServer();
        if (!server.func_152345_ab()) {
            server.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ManualTaskPacket.this.handleServer(player);
                }
            });
            return;
        }
        this.handleServer(player);
    }

    public void handleServer(EntityPlayer player) {
        if (this.mod == 0) {
            DeleteProcessor.INSTANCE.interruptTask();
            ChunkProcessor.INSTANCE.interruptTask(false);
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Stopped Processors");
            ChunkPregenerator.networking.sendPacketToPlayer(new ProcessAnswerPacket(false, TaskStorage.getStorage().hasTasks()), player);
        } else if (this.mod == 1) {
            DeleteProcessor.INSTANCE.interruptTask();
            ChunkProcessor.INSTANCE.interruptTask(false);
            TaskStorage.getStorage().clearAll();
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Stopped Processors & Cleared Tasks");
            ChunkPregenerator.networking.sendPacketToPlayer(new ProcessAnswerPacket(false, false), player);
        } else {
            TaskStorage storage = TaskStorage.getStorage();
            if (storage.hasTasks()) {
                ChunkProcessor.INSTANCE.startTask(storage.getNextTask());
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Started Pregenerator");
                ChunkPregenerator.networking.sendPacketToPlayer(new ProcessAnswerPacket(true, true), player);
            } else {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "No Tasks Aviable");
                ChunkPregenerator.networking.sendPacketToPlayer(new ProcessAnswerPacket(false, false), player);
            }
        }
    }
}

