/*
 * Decompiled with CFR 0.152.
 */
package net.dirtcraft.julian;

import com.google.inject.Inject;
import java.nio.file.Path;
import net.dirtcraft.julian.ConfigManager;
import net.dirtcraft.julian.Reload;
import net.dirtcraft.julian.SendMessage;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;

@Plugin(id="slashdiscord", name="Slash Discord", version="1.4.0", description="Creates a /discord command to show a fully customizable Discord link and message.", authors={"juliann"})
public class SlashDiscord {
    @Inject
    private Logger logger;
    @Inject
    private PluginContainer container;
    private CommandSource source;
    private static SlashDiscord instance;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path dir;

    @Listener
    public void onPreInit(GameInitializationEvent e) {
        instance = this;
        ConfigManager.setup(this.dir);
        ConfigManager.load();
        this.logger.info(this.container.getName() + "has successfully loaded config files!");
    }

    @Listener
    public void onGameInit(GameInitializationEvent e) {
        this.logger.info(this.container.getName() + " running (version " + this.container.getVersion().orElse("") + ")! Hey, I'm alive!");
        CommandSpec reloadCmd = CommandSpec.builder().description((Text)Text.of((String)"Reload command for Slash Discord")).executor((CommandExecutor)new Reload()).permission("slashdiscord.reload").build();
        CommandSpec command = CommandSpec.builder().description((Text)Text.of((String)"Base command for Slash Discord")).executor((CommandExecutor)new SendMessage()).child((CommandCallable)reloadCmd, new String[]{"reload", "rl"}).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)command, new String[]{"discord"});
    }

    @Listener
    public void onGameReload(GameReloadEvent e) {
        ConfigManager.load();
    }
}

