/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.SimpleColoredTexture;

public class InverseColoredTexture
extends SimpleColoredTexture {
    public InverseColoredTexture(int colorLow, int colorMid, int colorHigh, ResourceLocation baseTexture, String spriteName) {
        super(colorLow, colorMid, colorHigh, baseTexture, spriteName);
    }

    @Override
    protected int colorPixel(int pixel, int pxCoord) {
        int a = RenderUtil.alpha(pixel);
        if (a == 0) {
            return pixel;
        }
        int brightness = InverseColoredTexture.getPerceptualBrightness(pixel);
        int c = this.colorMid;
        if (brightness < this.minBrightness) {
            c = this.colorLow;
        } else if (brightness > this.maxBrightness) {
            c = this.colorHigh;
        }
        int r = RenderUtil.red(c);
        int b = RenderUtil.blue(c);
        int g = RenderUtil.green(c);
        r = ~InverseColoredTexture.mult(r, brightness) & 0xFF;
        g = ~InverseColoredTexture.mult(g, brightness) & 0xFF;
        b = ~InverseColoredTexture.mult(b, brightness) & 0xFF;
        return RenderUtil.compose(r, g, b, a);
    }
}

