/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import java.util.Collection;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.commands.log.LogNotify;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import net.luckperms.api.event.log.LogBroadcastEvent;
import net.luckperms.api.event.log.LogNotifyEvent;

public class LogDispatcher {
    private final LuckPermsPlugin plugin;

    public LogDispatcher(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    private boolean shouldBroadcast(LoggedAction entry, LogBroadcastEvent.Origin origin) {
        boolean cancelled = false;
        if (!this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY).booleanValue()) {
            cancelled = true;
        } else if (origin == LogBroadcastEvent.Origin.REMOTE && !this.plugin.getConfiguration().get(ConfigKeys.BROADCAST_RECEIVED_LOG_ENTRIES).booleanValue()) {
            cancelled = true;
        } else {
            Collection filters = this.plugin.getConfiguration().get(ConfigKeys.LOG_NOTIFY_FILTERED_DESCRIPTIONS);
            for (Pattern filter : filters) {
                if (!filter.matcher(entry.getDescription()).matches()) continue;
                cancelled = true;
                break;
            }
        }
        return !this.plugin.getEventDispatcher().dispatchLogBroadcast(cancelled, entry, origin);
    }

    private void broadcast(LoggedAction entry, LogNotifyEvent.Origin origin, Sender sender) {
        this.plugin.getOnlineSenders().filter(CommandPermission.LOG_NOTIFY::isAuthorized).filter(s -> {
            boolean shouldCancel = LogNotify.isIgnoring(this.plugin, s.getUniqueId()) || sender != null && s.getUniqueId().equals(sender.getUniqueId());
            return !this.plugin.getEventDispatcher().dispatchLogNotify(shouldCancel, entry, origin, (Sender)s);
        }).forEach(s -> Message.LOG.send((Sender)s, entry));
    }

    public void dispatch(LoggedAction entry, Sender sender) {
        if (!this.plugin.getEventDispatcher().dispatchLogPublish(false, entry)) {
            this.plugin.getStorage().logAction(entry);
        }
        this.plugin.getMessagingService().ifPresent(service -> service.pushLog(entry));
        if (this.shouldBroadcast(entry, LogBroadcastEvent.Origin.LOCAL)) {
            this.broadcast(entry, LogNotifyEvent.Origin.LOCAL, sender);
        }
    }

    public void broadcastFromApi(LoggedAction entry) {
        this.plugin.getMessagingService().ifPresent(extendedMessagingService -> extendedMessagingService.pushLog(entry));
        if (this.shouldBroadcast(entry, LogBroadcastEvent.Origin.LOCAL_API)) {
            this.broadcast(entry, LogNotifyEvent.Origin.LOCAL_API, null);
        }
    }

    public void dispatchFromApi(LoggedAction entry) {
        if (!this.plugin.getEventDispatcher().dispatchLogPublish(false, entry)) {
            try {
                this.plugin.getStorage().logAction(entry).get();
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("Error whilst storing action", e);
            }
        }
        this.broadcastFromApi(entry);
    }

    public void dispatchFromRemote(LoggedAction entry) {
        if (this.shouldBroadcast(entry, LogBroadcastEvent.Origin.REMOTE)) {
            this.broadcast(entry, LogNotifyEvent.Origin.REMOTE, null);
        }
    }
}

