/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import me.lucko.luckperms.common.cache.LoadingMap;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.cacheddata.UsageTracked;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.cacheddata.type.MetaCache;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.CaffeineFactory;
import net.luckperms.api.cacheddata.CachedData;
import net.luckperms.api.cacheddata.CachedDataManager;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractCachedDataManager
implements CachedDataManager {
    private final LuckPermsPlugin plugin;
    private final AbstractContainer<PermissionCache, CachedPermissionData> permission;
    private final AbstractContainer<MetaCache, CachedMetaData> meta;

    protected AbstractCachedDataManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        this.permission = new AbstractContainer(this::calculatePermissions);
        this.meta = new AbstractContainer(this::calculateMeta);
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public @NonNull CachedDataManager.Container<CachedPermissionData> permissionData() {
        return this.permission;
    }

    @Override
    public @NonNull CachedDataManager.Container<CachedMetaData> metaData() {
        return this.meta;
    }

    @Override
    public @NonNull PermissionCache getPermissionData(@NonNull QueryOptions queryOptions) {
        return this.permission.get(queryOptions);
    }

    @Override
    public @NonNull MetaCache getMetaData(@NonNull QueryOptions queryOptions) {
        return this.meta.get(queryOptions);
    }

    @Override
    public @NonNull PermissionCache getPermissionData() {
        return this.getPermissionData(this.getQueryOptions());
    }

    @Override
    public @NonNull MetaCache getMetaData() {
        return this.getMetaData(this.getQueryOptions());
    }

    protected abstract CacheMetadata getMetadataForQueryOptions(QueryOptions var1);

    protected abstract QueryOptions getQueryOptions();

    protected abstract CalculatorFactory getCalculatorFactory();

    protected abstract MetaStackDefinition getDefaultMetaStackDefinition(ChatMetaType var1);

    protected abstract <M extends Map<String, Boolean>> M resolvePermissions(IntFunction<M> var1, QueryOptions var2);

    protected abstract void resolveMeta(MetaAccumulator var1, QueryOptions var2);

    private PermissionCache calculatePermissions(QueryOptions queryOptions) {
        Objects.requireNonNull(queryOptions, "queryOptions");
        CacheMetadata metadata = this.getMetadataForQueryOptions(queryOptions);
        ConcurrentHashMap sourcePermissions = this.resolvePermissions(ConcurrentHashMap::new, queryOptions);
        return new PermissionCache(queryOptions, metadata, this.getCalculatorFactory(), sourcePermissions);
    }

    private MetaCache calculateMeta(QueryOptions queryOptions) {
        Objects.requireNonNull(queryOptions, "queryOptions");
        CacheMetadata metadata = this.getMetadataForQueryOptions(queryOptions);
        MetaAccumulator accumulator = this.newAccumulator(queryOptions);
        this.resolveMeta(accumulator, queryOptions);
        return new MetaCache(this.plugin, queryOptions, metadata, accumulator);
    }

    @Override
    public final void invalidate() {
        this.permission.invalidate();
        this.meta.invalidate();
    }

    @Override
    public final void invalidatePermissionCalculators() {
        ((AbstractContainer)this.permission).cache.values().forEach(PermissionCache::invalidateCache);
    }

    public final void performCacheCleanup() {
        this.permission.cleanup();
        this.meta.cleanup();
    }

    private MetaStackDefinition getMetaStackDefinition(QueryOptions queryOptions, ChatMetaType type) {
        MetaStackDefinition stack = queryOptions.option(type == ChatMetaType.PREFIX ? MetaStackDefinition.PREFIX_STACK_KEY : MetaStackDefinition.SUFFIX_STACK_KEY).orElse(null);
        if (stack == null) {
            stack = this.getDefaultMetaStackDefinition(type);
        }
        return stack;
    }

    private MetaAccumulator newAccumulator(QueryOptions queryOptions) {
        return new MetaAccumulator(this.getMetaStackDefinition(queryOptions, ChatMetaType.PREFIX), this.getMetaStackDefinition(queryOptions, ChatMetaType.SUFFIX));
    }

    private static final class AbstractContainer<C extends I, I extends CachedData>
    implements CachedDataManager.Container<I> {
        private final Function<QueryOptions, C> cacheLoader;
        private final LoadingMap<QueryOptions, C> cache;

        public AbstractContainer(Function<QueryOptions, C> cacheLoader) {
            this.cacheLoader = cacheLoader;
            this.cache = LoadingMap.of(this.cacheLoader);
        }

        public void cleanup() {
            this.cache.values().removeIf(value -> ((UsageTracked)((Object)value)).usedSince(TimeUnit.MINUTES.toMillis(2L)));
        }

        @Override
        public @NonNull C get(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            CachedData data = (CachedData)this.cache.get(queryOptions);
            ((UsageTracked)((Object)data)).recordUsage();
            return (C)data;
        }

        @Override
        public @NonNull C calculate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            return (C)((CachedData)this.cacheLoader.apply(queryOptions));
        }

        @Override
        public void recalculate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            CompletableFuture.runAsync(() -> {
                CachedData value = (CachedData)this.cacheLoader.apply(queryOptions);
                this.cache.put(queryOptions, value);
            }, CaffeineFactory.executor());
        }

        @Override
        public @NonNull CompletableFuture<? extends C> reload(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            this.cache.remove(queryOptions);
            return CompletableFuture.supplyAsync(() -> (CachedData)this.cache.get(queryOptions), CaffeineFactory.executor());
        }

        @Override
        public void recalculate() {
            Set keys = this.cache.keySet();
            keys.forEach(this::recalculate);
        }

        @Override
        public @NonNull CompletableFuture<Void> reload() {
            Set keys = this.cache.keySet();
            return CompletableFuture.allOf((CompletableFuture[])keys.stream().map(this::reload).toArray(CompletableFuture[]::new));
        }

        @Override
        public void invalidate(@NonNull QueryOptions queryOptions) {
            Objects.requireNonNull(queryOptions, "queryOptions");
            this.cache.remove(queryOptions);
        }

        @Override
        public void invalidate() {
            this.cache.clear();
        }
    }
}

