/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.luckperms.common.cacheddata.type.MetaStackAccumulator;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;

public class MetaAccumulator {
    private final AtomicReference<State> state = new AtomicReference<State>(State.ACCUMULATING);
    private final ListMultimap<String, String> meta;
    private final SortedMap<Integer, String> prefixes;
    private final SortedMap<Integer, String> suffixes;
    private int weight = 0;
    private String primaryGroup;
    private final MetaStackDefinition prefixDefinition;
    private final MetaStackDefinition suffixDefinition;
    private final MetaStackAccumulator prefixAccumulator;
    private final MetaStackAccumulator suffixAccumulator;

    public static MetaAccumulator makeFromConfig(LuckPermsPlugin plugin) {
        return new MetaAccumulator(plugin.getConfiguration().get(ConfigKeys.PREFIX_FORMATTING_OPTIONS), plugin.getConfiguration().get(ConfigKeys.SUFFIX_FORMATTING_OPTIONS));
    }

    public MetaAccumulator(MetaStackDefinition prefixDefinition, MetaStackDefinition suffixDefinition) {
        Objects.requireNonNull(prefixDefinition, "prefixDefinition");
        Objects.requireNonNull(suffixDefinition, "suffixDefinition");
        this.meta = ArrayListMultimap.create();
        this.prefixes = new TreeMap(Comparator.reverseOrder());
        this.suffixes = new TreeMap(Comparator.reverseOrder());
        this.prefixDefinition = prefixDefinition;
        this.suffixDefinition = suffixDefinition;
        this.prefixAccumulator = new MetaStackAccumulator(this.prefixDefinition, ChatMetaType.PREFIX);
        this.suffixAccumulator = new MetaStackAccumulator(this.suffixDefinition, ChatMetaType.SUFFIX);
    }

    private void ensureState(State state) {
        if (this.state.get() != state) {
            throw new IllegalStateException("State must be " + (Object)((Object)state) + ", but is actually " + (Object)((Object)this.state.get()));
        }
    }

    public void complete() {
        if (!this.state.compareAndSet(State.ACCUMULATING, State.COMPLETING)) {
            return;
        }
        if (!this.meta.containsKey((Object)"weight") && this.weight != 0) {
            this.meta.put((Object)"weight", (Object)String.valueOf(this.weight));
        }
        if (this.primaryGroup != null && !this.meta.containsKey((Object)"primarygroup")) {
            this.meta.put((Object)"primarygroup", (Object)this.primaryGroup);
        }
        this.state.set(State.COMPLETE);
    }

    public void accumulateNode(Node n) {
        ChatMetaNode<PrefixNode, PrefixNode.Builder> pn;
        this.ensureState(State.ACCUMULATING);
        if (n instanceof MetaNode) {
            MetaNode mn = (MetaNode)n;
            this.meta.put((Object)mn.getMetaKey(), (Object)mn.getMetaValue());
        }
        if (n instanceof PrefixNode) {
            pn = (PrefixNode)n;
            this.prefixes.putIfAbsent(pn.getPriority(), pn.getMetaValue());
            this.prefixAccumulator.offer(pn);
        }
        if (n instanceof SuffixNode) {
            pn = (SuffixNode)n;
            this.suffixes.putIfAbsent(pn.getPriority(), pn.getMetaValue());
            this.suffixAccumulator.offer(pn);
        }
    }

    public void accumulateMeta(String key, String value) {
        this.ensureState(State.ACCUMULATING);
        this.meta.put((Object)key, (Object)value);
    }

    public void accumulateWeight(int weight) {
        this.ensureState(State.ACCUMULATING);
        this.weight = Math.max(this.weight, weight);
    }

    public void setPrimaryGroup(String primaryGroup) {
        this.ensureState(State.ACCUMULATING);
        this.primaryGroup = primaryGroup;
    }

    public ListMultimap<String, String> getMeta() {
        this.ensureState(State.COMPLETE);
        return this.meta;
    }

    public Map<Integer, String> getChatMeta(ChatMetaType type) {
        this.ensureState(State.COMPLETE);
        return type == ChatMetaType.PREFIX ? this.prefixes : this.suffixes;
    }

    public SortedMap<Integer, String> getPrefixes() {
        this.ensureState(State.COMPLETE);
        return this.prefixes;
    }

    public SortedMap<Integer, String> getSuffixes() {
        this.ensureState(State.COMPLETE);
        return this.suffixes;
    }

    public int getWeight() {
        this.ensureState(State.COMPLETE);
        return this.weight;
    }

    public String getPrimaryGroup() {
        this.ensureState(State.COMPLETE);
        return this.primaryGroup;
    }

    public MetaStackDefinition getPrefixDefinition() {
        this.ensureState(State.COMPLETE);
        return this.prefixDefinition;
    }

    public MetaStackDefinition getSuffixDefinition() {
        this.ensureState(State.COMPLETE);
        return this.suffixDefinition;
    }

    public String getPrefix() {
        this.ensureState(State.COMPLETE);
        return this.prefixAccumulator.toFormattedString();
    }

    public String getSuffix() {
        this.ensureState(State.COMPLETE);
        return this.suffixAccumulator.toFormattedString();
    }

    public String toString() {
        return "MetaAccumulator(meta=" + this.meta + ", prefixes=" + this.prefixes + ", suffixes=" + this.suffixes + ", weight=" + this.weight + ", primaryGroup=" + this.primaryGroup + ", prefixStack=" + this.prefixAccumulator + ", suffixStack=" + this.suffixAccumulator + ")";
    }

    private static enum State {
        ACCUMULATING,
        COMPLETING,
        COMPLETE;

    }
}

