/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.other;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.lib.adventure.text.BuildableComponent;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;

public class HolderShowTracks<T extends PermissionHolder>
extends ChildCommand<T> {
    public HolderShowTracks(HolderType type) {
        super(CommandSpec.HOLDER_SHOWTRACKS, "showtracks", type == HolderType.USER ? CommandPermission.USER_SHOW_TRACKS : CommandPermission.GROUP_SHOW_TRACKS, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, T target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        try {
            plugin.getStorage().loadAllTracks().get();
        }
        catch (Exception e) {
            plugin.getLogger().warn("Error whilst loading tracks", e);
            Message.TRACKS_LOAD_ERROR.send(sender);
            return CommandResult.LOADING_ERROR;
        }
        ArrayList<Map.Entry> lines = new ArrayList<Map.Entry>();
        if (((PermissionHolder)target).getType() == HolderType.USER) {
            Set nodes = ((PermissionHolder)target).normalData().inheritanceAsList().stream().filter(Node::getValue).filter(n -> !n.hasExpiry()).collect(Collectors.toSet());
            for (InheritanceNode node : nodes) {
                String groupName = node.getGroupName();
                List tracks = plugin.getTrackManager().getAll().values().stream().filter(t -> t.containsGroup(groupName)).collect(Collectors.toList());
                for (Track track : tracks) {
                    BuildableComponent line = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).append((Component)Component.newline())).append(Message.formatTrackPath(track.getGroups(), groupName))).build();
                    lines.add(Maps.immutableEntry((Object)track, (Object)line));
                }
            }
        } else {
            String groupName = ((Group)target).getName();
            List tracks = plugin.getTrackManager().getAll().values().stream().filter(t -> t.containsGroup(groupName)).collect(Collectors.toList());
            for (Track track : tracks) {
                lines.add(Maps.immutableEntry((Object)track, (Object)Message.formatTrackPath(track.getGroups(), groupName)));
            }
        }
        if (lines.isEmpty()) {
            Message.LIST_TRACKS_EMPTY.send(sender, (PermissionHolder)target);
            return CommandResult.SUCCESS;
        }
        Message.LIST_TRACKS.send(sender, (PermissionHolder)target);
        for (Map.Entry line : lines) {
            Message.LIST_TRACKS_ENTRY.send(sender, ((Track)line.getKey()).getName(), (Component)line.getValue());
        }
        return CommandResult.SUCCESS;
    }
}

