/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.metastacking;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.luckperms.api.metastacking.DuplicateRemovalFunction;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.metastacking.MetaStackElement;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SimpleMetaStackDefinition
implements MetaStackDefinition {
    private final List<MetaStackElement> elements;
    private final DuplicateRemovalFunction duplicateRemovalFunction;
    private final String startSpacer;
    private final String middleSpacer;
    private final String endSpacer;
    private final int hashCode;

    public SimpleMetaStackDefinition(List<MetaStackElement> elements, DuplicateRemovalFunction duplicateRemovalFunction, String startSpacer, String middleSpacer, String endSpacer) {
        this.elements = ImmutableList.copyOf((Collection)Objects.requireNonNull(elements, "elements"));
        this.duplicateRemovalFunction = Objects.requireNonNull(duplicateRemovalFunction, "duplicateRemovalFunction");
        this.startSpacer = Objects.requireNonNull(startSpacer, "startSpacer");
        this.middleSpacer = Objects.requireNonNull(middleSpacer, "middleSpacer");
        this.endSpacer = Objects.requireNonNull(endSpacer, "endSpacer");
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public @NonNull List<MetaStackElement> getElements() {
        return this.elements;
    }

    @Override
    public @NonNull DuplicateRemovalFunction getDuplicateRemovalFunction() {
        return this.duplicateRemovalFunction;
    }

    @Override
    public @NonNull String getStartSpacer() {
        return this.startSpacer;
    }

    @Override
    public @NonNull String getMiddleSpacer() {
        return this.middleSpacer;
    }

    @Override
    public @NonNull String getEndSpacer() {
        return this.endSpacer;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleMetaStackDefinition)) {
            return false;
        }
        SimpleMetaStackDefinition that = (SimpleMetaStackDefinition)o;
        return this.elements.equals(that.elements) && this.duplicateRemovalFunction.equals(that.duplicateRemovalFunction) && this.startSpacer.equals(that.startSpacer) && this.middleSpacer.equals(that.middleSpacer) && this.endSpacer.equals(that.endSpacer);
    }

    private int calculateHashCode() {
        return Objects.hash(this.elements, this.duplicateRemovalFunction, this.startSpacer, this.middleSpacer, this.elements);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "SimpleMetaStackDefinition(elements=" + this.elements + ", duplicateRemovalFunction=" + this.duplicateRemovalFunction + ", startSpacer=" + this.startSpacer + ", middleSpacer=" + this.middleSpacer + ", endSpacer=" + this.endSpacer + ")";
    }
}

