/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.common.actionlog.ActionJsonSerializer;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.cache.BufferedRequest;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import net.luckperms.api.actionlog.Action;

public class FileActionLogger {
    private Path contentFile;
    private final ReentrantLock writeLock = new ReentrantLock();
    private final Queue<Action> entryQueue = new ConcurrentLinkedQueue<Action>();
    private final SaveBuffer saveBuffer;

    public FileActionLogger(LuckPermsPlugin plugin) {
        this.saveBuffer = new SaveBuffer(plugin);
    }

    public void init(Path contentFile, Path legacyFile) {
        this.contentFile = contentFile;
        if (Files.exists(legacyFile, new LinkOption[0])) {
            JsonArray array;
            try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(legacyFile, StandardCharsets.UTF_8));){
                array = GsonProvider.parser().parse(reader).getAsJsonArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            for (JsonElement element : array) {
                this.entryQueue.add(ActionJsonSerializer.deserialize(element));
            }
            this.flush();
            try {
                Files.delete(legacyFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void logAction(Action entry) {
        this.entryQueue.add(entry);
        this.saveBuffer.request();
    }

    public void flush() {
        this.writeLock.lock();
        try {
            if (this.entryQueue.peek() == null) {
                return;
            }
            try {
                Action e;
                ArrayList<String> toWrite = new ArrayList<String>(this.entryQueue.size());
                while ((e = this.entryQueue.poll()) != null) {
                    toWrite.add(GsonProvider.normal().toJson((JsonElement)ActionJsonSerializer.serialize(e)));
                }
                Files.write(this.contentFile, toWrite, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Log getLog() throws IOException {
        if (!Files.exists(this.contentFile, new LinkOption[0])) {
            return Log.empty();
        }
        Log.Builder log = Log.builder();
        try (BufferedReader reader = Files.newBufferedReader(this.contentFile, StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    JsonElement parsed = GsonProvider.parser().parse(line);
                    log.add(ActionJsonSerializer.deserialize(parsed));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return log.build();
    }

    private final class SaveBuffer
    extends BufferedRequest<Void> {
        public SaveBuffer(LuckPermsPlugin plugin) {
            super(2L, TimeUnit.SECONDS, plugin.getBootstrap().getScheduler());
        }

        @Override
        protected Void perform() {
            FileActionLogger.this.flush();
            return null;
        }
    }
}

