/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.treeview;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.common.treeview.ImmutableTreeNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TreeNode {
    private Map<String, TreeNode> children = null;
    private final int level;

    private static boolean allowInsert(TreeNode node) {
        if (node.level == 0) {
            return true;
        }
        if (node.level <= 2) {
            return node.getChildrenSize() < 500;
        }
        return node.getChildrenSize() < 100;
    }

    public TreeNode() {
        this.level = 0;
    }

    TreeNode(TreeNode parent) {
        this.level = parent.level + 1;
    }

    private synchronized Map<String, TreeNode> getChildMap() {
        if (this.children == null) {
            this.children = new ConcurrentHashMap<String, TreeNode>();
        }
        return this.children;
    }

    public @Nullable TreeNode tryInsert(String s) {
        Map<String, TreeNode> childMap = this.getChildMap();
        if (!TreeNode.allowInsert(this)) {
            return null;
        }
        return childMap.computeIfAbsent(s, x -> new TreeNode(this));
    }

    public Optional<Map<String, TreeNode>> getChildren() {
        return Optional.ofNullable(this.children);
    }

    public int getChildrenSize() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public ImmutableTreeNode makeImmutableCopy() {
        if (this.children == null) {
            return new ImmutableTreeNode(null);
        }
        return new ImmutableTreeNode(this.children.entrySet().stream().map(e -> Maps.immutableEntry((Object)((String)e.getKey()), (Object)((TreeNode)e.getValue()).makeImmutableCopy())));
    }
}

