/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import java.util.UUID;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.format.NamedTextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;

public final class UniqueIdType {
    public static final UniqueIdType AUTHENTICATED = new UniqueIdType("authenticated", (Component)Component.translatable((String)"luckperms.command.user.info.uuid-type.mojang", (TextColor)NamedTextColor.DARK_GREEN));
    public static final UniqueIdType UNAUTHENTICATED = new UniqueIdType("unauthenticated", (Component)Component.translatable((String)"luckperms.command.user.info.uuid-type.not-mojang", (TextColor)NamedTextColor.DARK_GRAY));
    private static final String TYPE_NPC = "npc";
    public static final UniqueIdType NPC = new UniqueIdType("npc");
    private final String type;
    private final Component component;

    public static UniqueIdType determineType(UUID uniqueId, LuckPermsPlugin plugin) {
        String type;
        switch (uniqueId.version()) {
            case 4: {
                type = "authenticated";
                break;
            }
            case 3: {
                type = "unauthenticated";
                break;
            }
            case 2: {
                type = TYPE_NPC;
                break;
            }
            default: {
                type = "unknown";
            }
        }
        switch (type = plugin.getEventDispatcher().dispatchUniqueIdDetermineType(uniqueId, type)) {
            case "authenticated": {
                return AUTHENTICATED;
            }
            case "unauthenticated": {
                return UNAUTHENTICATED;
            }
            case "npc": {
                return NPC;
            }
        }
        return new UniqueIdType(type);
    }

    private UniqueIdType(String type) {
        this(type, (Component)Component.text((String)type, (TextColor)NamedTextColor.GOLD));
    }

    private UniqueIdType(String type, Component component) {
        this.type = type;
        this.component = component;
    }

    public String getType() {
        return this.type;
    }

    public Component describe() {
        return this.component;
    }
}

