/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.permissionholder;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import me.lucko.luckperms.common.cacheddata.type.MetaCache;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;
import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import me.lucko.luckperms.common.verbose.event.PermissionCheckEvent;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.model.SpongeGroup;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.ProxyFactory;
import me.lucko.luckperms.sponge.service.events.UpdateEventHandler;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.model.ProxiedSubject;
import me.lucko.luckperms.sponge.service.model.permissionholder.PermissionHolderSubjectData;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;

public abstract class PermissionHolderSubject<T extends PermissionHolder>
implements LPSubject {
    protected final T parent;
    protected final LPSpongePlugin plugin;
    private final PermissionHolderSubjectData subjectData;
    private final PermissionHolderSubjectData transientSubjectData;
    private ProxiedSubject spongeSubject = null;

    PermissionHolderSubject(LPSpongePlugin plugin, T parent) {
        this.parent = parent;
        this.plugin = plugin;
        this.subjectData = new PermissionHolderSubjectData(plugin.getService(), DataType.NORMAL, (PermissionHolder)parent, this);
        this.transientSubjectData = new PermissionHolderSubjectData(plugin.getService(), DataType.TRANSIENT, (PermissionHolder)parent, this);
    }

    public void fireUpdateEvent() {
        UpdateEventHandler.fireUpdateEvent(this.plugin, this.subjectData);
        UpdateEventHandler.fireUpdateEvent(this.plugin, this.transientSubjectData);
    }

    public T getParent() {
        return this.parent;
    }

    @Override
    public synchronized ProxiedSubject sponge() {
        if (this.spongeSubject == null) {
            this.spongeSubject = ProxyFactory.toSponge(this);
        }
        return this.spongeSubject;
    }

    @Override
    public LuckPermsService getService() {
        return this.plugin.getService();
    }

    @Override
    public LPSubject getDefaults() {
        return this.plugin.getService().getDefaultSubjects().getTypeDefaults(this.getParentCollection().getIdentifier());
    }

    @Override
    public PermissionHolderSubjectData getSubjectData() {
        return this.subjectData;
    }

    @Override
    public PermissionHolderSubjectData getTransientSubjectData() {
        return this.transientSubjectData;
    }

    @Override
    public Tristate getPermissionValue(QueryOptions options, String permission) {
        return ((PermissionHolder)this.parent).getCachedData().getPermissionData(options).checkPermission(permission, PermissionCheckEvent.Origin.PLATFORM_LOOKUP_CHECK).result();
    }

    @Override
    public Tristate getPermissionValue(ImmutableContextSet contexts, String permission) {
        QueryOptions queryOptions = this.plugin.getContextManager().formQueryOptions(contexts);
        return this.getPermissionValue(queryOptions, permission);
    }

    @Override
    public boolean isChildOf(ImmutableContextSet contexts, LPSubjectReference parent) {
        return parent.getCollectionIdentifier().equals("group") && this.getPermissionValue(contexts, Inheritance.key(parent.getSubjectIdentifier())).asBoolean();
    }

    @Override
    public ImmutableList<LPSubjectReference> getParents(ImmutableContextSet contexts) {
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(this.plugin.getContextManager().formQueryOptions(contexts));
        Iterable<T> traversal = graph.traverse(TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER, this.parent);
        ImmutableList.Builder subjects = ImmutableList.builder();
        for (PermissionHolder parent : traversal) {
            if (!(parent instanceof Group)) continue;
            subjects.add((Object)((SpongeGroup)parent).sponge().toReference());
        }
        return subjects.build();
    }

    @Override
    public Optional<String> getOption(ImmutableContextSet contexts, String s) {
        String suffix;
        String prefix;
        MetaCache data = ((PermissionHolder)this.parent).getCachedData().getMetaData(this.plugin.getContextManager().formQueryOptions(contexts));
        if (s.equalsIgnoreCase("prefix") && (prefix = data.getPrefix(MetaCheckEvent.Origin.PLATFORM_API)) != null) {
            return Optional.of(prefix);
        }
        if (s.equalsIgnoreCase("suffix") && (suffix = data.getSuffix(MetaCheckEvent.Origin.PLATFORM_API)) != null) {
            return Optional.of(suffix);
        }
        String val = data.getMetaValue(s, MetaCheckEvent.Origin.PLATFORM_API);
        if (val != null) {
            return Optional.of(val);
        }
        Optional<String> v = this.getParentCollection().getDefaults().getOption(contexts, s);
        if (v.isPresent()) {
            return v;
        }
        return this.plugin.getService().getRootDefaults().getOption(contexts, s);
    }

    @Override
    public void performCacheCleanup() {
    }

    @Override
    public void invalidateCaches() {
        ((PermissionHolder)this.parent).getCachedData().invalidate();
    }
}

