/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.permissionholder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.node.types.Meta;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.ProxyFactory;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.util.Tristate;
import org.spongepowered.api.service.permission.SubjectData;

public class PermissionHolderSubjectData
implements LPSubjectData {
    private final LuckPermsService service;
    private final DataType type;
    private final PermissionHolder holder;
    private final LPSubject parentSubject;

    public PermissionHolderSubjectData(LuckPermsService service, DataType type, PermissionHolder holder, LPSubject parentSubject) {
        this.type = type;
        this.service = service;
        this.holder = holder;
        this.parentSubject = parentSubject;
    }

    @Override
    public SubjectData sponge() {
        return ProxyFactory.toSponge(this);
    }

    @Override
    public LPSubject getParentSubject() {
        return this.parentSubject;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableMap<String, Boolean>> getAllPermissions() {
        ImmutableMap.Builder permissions = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, Collection<Node>> entry : this.holder.getData(this.type).asMap().entrySet()) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Node n : entry.getValue()) {
                builder.put((Object)n.getKey(), (Object)n.getValue());
            }
            permissions.put((Object)entry.getKey(), (Object)builder.build());
        }
        return permissions.build();
    }

    @Override
    public ImmutableMap<String, Boolean> getPermissions(ImmutableContextSet contexts) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Node n : this.holder.getData(this.type).nodesInContext(contexts)) {
            builder.put((Object)n.getKey(), (Object)n.getValue());
        }
        return builder.build();
    }

    @Override
    public CompletableFuture<Boolean> setPermission(ImmutableContextSet contexts, String permission, Tristate tristate) {
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(permission, "permission");
        Objects.requireNonNull(tristate, "tristate");
        if (tristate == Tristate.UNDEFINED) {
            Object node = NodeBuilders.determineMostApplicable(permission).withContext(contexts).build();
            this.holder.unsetNode(this.type, (Node)node);
            return this.save(this.holder).thenApply(v -> true);
        }
        Object node = NodeBuilders.determineMostApplicable(permission).value(tristate.asBoolean()).withContext(contexts).build();
        this.holder.unsetNode(this.type, (Node)node);
        this.holder.setNode(this.type, (Node)node, true);
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions() {
        if (!this.holder.clearNodes(this.type, null, true)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions(ImmutableContextSet contexts) {
        Objects.requireNonNull(contexts, "contexts");
        if (!this.holder.clearNodes(this.type, contexts, true)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableList<LPSubjectReference>> getAllParents() {
        ImmutableMap.Builder parents = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, Collection<InheritanceNode>> entry : this.holder.getData(this.type).inheritanceAsMap().entrySet()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (InheritanceNode n : entry.getValue()) {
                builder.add((Object)this.service.getGroupSubjects().loadSubject(n.getGroupName()).join().toReference());
            }
            parents.put((Object)entry.getKey(), (Object)builder.build());
        }
        return parents.build();
    }

    @Override
    public ImmutableList<LPSubjectReference> getParents(ImmutableContextSet contexts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (InheritanceNode n : this.holder.getData(this.type).inheritanceNodesInContext(contexts)) {
            builder.add((Object)this.service.getGroupSubjects().loadSubject(n.getGroupName()).join().toReference());
        }
        return builder.build();
    }

    @Override
    public CompletableFuture<Boolean> addParent(ImmutableContextSet contexts, LPSubjectReference subject) {
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(subject, "subject");
        if (!subject.getCollectionIdentifier().equals("group")) {
            return CompletableFuture.completedFuture(false);
        }
        Object node = ((InheritanceNode.Builder)Inheritance.builder(subject.getSubjectIdentifier()).withContext(contexts)).build();
        if (!this.holder.setNode(this.type, (Node)node, true).wasSuccessful()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> removeParent(ImmutableContextSet contexts, LPSubjectReference subject) {
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(subject, "subject");
        if (!subject.getCollectionIdentifier().equals("group")) {
            return CompletableFuture.completedFuture(false);
        }
        Object node = ((InheritanceNode.Builder)Inheritance.builder(subject.getSubjectIdentifier()).withContext(contexts)).build();
        if (!this.holder.unsetNode(this.type, (Node)node).wasSuccessful()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearParents() {
        if (!this.holder.removeIf(this.type, null, NodeType.INHERITANCE::matches, true)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearParents(ImmutableContextSet contexts) {
        Objects.requireNonNull(contexts, "contexts");
        if (!this.holder.removeIf(this.type, contexts, NodeType.INHERITANCE::matches, true)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableMap<String, String>> getAllOptions() {
        ImmutableMap.Builder options = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, Collection<Node>> entry : this.holder.getData(this.type).asMap().entrySet()) {
            options.put((Object)entry.getKey(), PermissionHolderSubjectData.nodesToOptions((Iterable<? extends Node>)entry.getValue()));
        }
        return options.build();
    }

    @Override
    public ImmutableMap<String, String> getOptions(ImmutableContextSet contexts) {
        return PermissionHolderSubjectData.nodesToOptions(this.holder.getData(this.type).nodesInContext(contexts));
    }

    private static ImmutableMap<String, String> nodesToOptions(Iterable<? extends Node> nodes) {
        HashMap<String, String> builder = new HashMap<String, String>();
        int maxPrefixPriority = Integer.MIN_VALUE;
        int maxSuffixPriority = Integer.MIN_VALUE;
        for (Node node : nodes) {
            if (!node.getValue() || !NodeType.META_OR_CHAT_META.matches(node)) continue;
            if (node instanceof PrefixNode) {
                PrefixNode pn = (PrefixNode)node;
                if (pn.getPriority() <= maxPrefixPriority) continue;
                builder.put("prefix", pn.getMetaValue());
                maxPrefixPriority = pn.getPriority();
                continue;
            }
            if (node instanceof SuffixNode) {
                SuffixNode sn = (SuffixNode)node;
                if (sn.getPriority() <= maxSuffixPriority) continue;
                builder.put("suffix", sn.getMetaValue());
                maxSuffixPriority = sn.getPriority();
                continue;
            }
            if (!(node instanceof MetaNode)) continue;
            MetaNode mn = (MetaNode)node;
            builder.put(mn.getMetaKey(), mn.getMetaValue());
        }
        return ImmutableMap.copyOf(builder);
    }

    @Override
    public CompletableFuture<Boolean> setOption(ImmutableContextSet contexts, String key, String value) {
        Object node;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (key.equalsIgnoreCase("prefix") || key.equalsIgnoreCase("suffix")) {
            ChatMetaType type = ChatMetaType.valueOf(key.toUpperCase());
            this.holder.removeIf(this.type, contexts, type.nodeType()::matches, false);
            MetaAccumulator metaAccumulator = this.holder.accumulateMeta(QueryOptionsImpl.DEFAULT_CONTEXTUAL.toBuilder().context(contexts).build());
            int priority = metaAccumulator.getChatMeta(type).keySet().stream().mapToInt(e -> e).max().orElse(0);
            node = ((ChatMetaNode.Builder)type.builder(value, priority += 10).withContext(contexts)).build();
        } else {
            this.holder.removeIf(this.type, contexts, NodeType.META.predicate(n -> n.getMetaKey().equals(key)), false);
            node = ((MetaNode.Builder)Meta.builder(key, value).withContext(contexts)).build();
        }
        this.holder.setNode(this.type, (Node)node, true);
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> unsetOption(ImmutableContextSet contexts, String key) {
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(key, "key");
        Predicate<Node> test = key.equalsIgnoreCase("prefix") ? NodeType.PREFIX::matches : (key.equalsIgnoreCase("suffix") ? NodeType.SUFFIX::matches : NodeType.META.predicate(mn -> mn.getMetaKey().equals(key)));
        if (!this.holder.removeIf(this.type, contexts, test, false)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions(ImmutableContextSet contexts) {
        Objects.requireNonNull(contexts, "contexts");
        if (!this.holder.removeIf(this.type, contexts, NodeType.META_OR_CHAT_META::matches, false)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions() {
        if (!this.holder.removeIf(this.type, null, NodeType.META_OR_CHAT_META::matches, false)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.save(this.holder).thenApply(v -> true);
    }

    private CompletableFuture<Void> save(PermissionHolder t) {
        if (t.getType() == HolderType.GROUP) {
            this.service.getPlugin().getGroupManager().invalidateAllGroupCaches();
            this.service.getPlugin().getUserManager().invalidateAllUserCaches();
        }
        if (this.type == DataType.TRANSIENT) {
            return CompletableFuture.completedFuture(null);
        }
        if (t.getType() == HolderType.USER) {
            User user = (User)t;
            return this.service.getPlugin().getStorage().saveUser(user);
        }
        Group group = (Group)t;
        return this.service.getPlugin().getStorage().saveGroup(group);
    }
}

