/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.actionlog;

import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import net.luckperms.api.LuckPermsProvider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Action
extends Comparable<Action> {
    public static @NonNull Builder builder() {
        return LuckPermsProvider.get().getActionLogger().actionBuilder();
    }

    public @NonNull Instant getTimestamp();

    public @NonNull Source getSource();

    public @NonNull Target getTarget();

    public @NonNull String getDescription();

    public static interface Builder {
        public @NonNull Builder timestamp(@NonNull Instant var1);

        public @NonNull Builder source(@NonNull UUID var1);

        public @NonNull Builder sourceName(@NonNull String var1);

        public @NonNull Builder targetType(Target.Type var1);

        public @NonNull Builder target(@Nullable UUID var1);

        public @NonNull Builder targetName(@NonNull String var1);

        public @NonNull Builder description(@NonNull String var1);

        public @NonNull Action build();
    }

    public static interface Target {
        public @NonNull Optional<UUID> getUniqueId();

        public @NonNull String getName();

        public @NonNull Type getType();

        public static enum Type {
            USER,
            GROUP,
            TRACK;

        }
    }

    public static interface Source {
        public @NonNull UUID getUniqueId();

        public @NonNull String getName();
    }
}

