/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.node;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface Node {
    public static @NonNull NodeBuilder<?, ?> builder(@NonNull String key) {
        return LuckPermsProvider.get().getNodeBuilderRegistry().forKey(key);
    }

    public @NonNull NodeType<?> getType();

    public @NonNull String getKey();

    public boolean getValue();

    default public boolean isNegated() {
        return !this.getValue();
    }

    public @NonNull @Unmodifiable Collection<String> resolveShorthand();

    public boolean hasExpiry();

    public @Nullable Instant getExpiry();

    public boolean hasExpired();

    public @Nullable Duration getExpiryDuration();

    public @NonNull ImmutableContextSet getContexts();

    public <T> Optional<T> getMetadata(NodeMetadataKey<T> var1);

    default public <T> T metadata(NodeMetadataKey<T> key) throws IllegalStateException {
        return this.getMetadata(key).orElseThrow(() -> new IllegalStateException("Node '" + this.getKey() + "' does not have '" + key.name() + "' attached."));
    }

    public boolean equals(Object var1);

    public boolean equals(@NonNull Node var1, @NonNull NodeEqualityPredicate var2);

    public @NonNull NodeBuilder<?, ?> toBuilder();
}

