/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.worldportals.common.portal;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTransformationStack {
    private final Deque<EntityTransformation> stack = new ArrayDeque<EntityTransformation>();
    private final Entity entity;

    public EntityTransformationStack(Entity ent) {
        this.entity = ent;
    }

    public void push() {
        this.stack.push(new EntityTransformationSeparator());
    }

    public void pop() {
        EntityTransformation last;
        while ((last = this.stack.poll()) != null && !(last instanceof EntityTransformationSeparator)) {
            last.revert();
        }
    }

    public void translate(double x, double y, double z) {
        EntityTransformation transformation = new EntityTransformation(x, y, z, 0.0f, 0.0f, 0.0f);
        this.stack.push(transformation);
        transformation.apply();
    }

    public void rotate(float yaw, float pitch, float roll) {
        EntityTransformation transformation = new EntityTransformation(0.0, 0.0, 0.0, yaw, pitch, roll);
        this.stack.push(transformation);
        transformation.apply();
    }

    public EntityTransformationStack moveEntity(double destX, double destY, double destZ, float[] pos, float[] rot, float partialTicks) {
        this.push();
        double ePosX = this.entity.field_70142_S + (this.entity.field_70165_t - this.entity.field_70142_S) * (double)partialTicks;
        double ePosY = this.entity.field_70137_T + (this.entity.field_70163_u - this.entity.field_70137_T) * (double)partialTicks + (double)this.entity.func_70047_e();
        double ePosZ = this.entity.field_70136_U + (this.entity.field_70161_v - this.entity.field_70136_U) * (double)partialTicks;
        this.translate(destX - ePosX + (double)pos[0], destY - ePosY + (double)pos[1], destZ - ePosZ + (double)pos[2]);
        this.rotate(rot[0], rot[1], rot[2]);
        return this;
    }

    public void reset() {
        this.pop();
    }

    private class EntityTransformationSeparator
    extends EntityTransformation {
        private EntityTransformationSeparator() {
        }
    }

    private class EntityTransformation {
        private double x;
        private double y;
        private double z;
        private float yaw;
        private float pitch;
        private float roll;

        public EntityTransformation(double x, double y, double z, float yaw, float pitch, float roll) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.roll = roll;
        }

        public EntityTransformation() {
        }

        public void apply() {
            if (((EntityTransformationStack)EntityTransformationStack.this).entity.field_70170_p.field_72995_K) {
                this.applyClient();
            } else {
                this.applyMain();
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void applyClient() {
            EntityPlayerSP player;
            float prevYaw = 0.0f;
            float yaw = 0.0f;
            float prevPitch = 0.0f;
            float pitch = 0.0f;
            if (EntityTransformationStack.this.entity instanceof EntityPlayerSP) {
                player = (EntityPlayerSP)EntityTransformationStack.this.entity;
                prevYaw = player.field_70126_B - player.field_71163_h;
                yaw = player.field_70177_z - player.field_71154_f;
                prevPitch = player.field_70127_C - player.field_71164_i;
                pitch = player.field_70125_A - player.field_71155_g;
            }
            this.applyMain();
            if (EntityTransformationStack.this.entity instanceof EntityPlayerSP) {
                player = (EntityPlayerSP)EntityTransformationStack.this.entity;
                player.field_71163_h = player.field_70126_B;
                player.field_71154_f = player.field_70177_z;
                player.field_71164_i = player.field_70127_C;
                player.field_71155_g = player.field_70125_A;
                player.field_71163_h -= prevYaw;
                player.field_71154_f -= yaw;
                player.field_71164_i -= prevPitch;
                player.field_71155_g -= pitch;
            }
        }

        private void applyMain() {
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70165_t += this.x;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70163_u += this.y;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70161_v += this.z;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70169_q += this.x;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70167_r += this.y;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70166_s += this.z;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70142_S += this.x;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70137_T += this.y;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70136_U += this.z;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70125_A += this.pitch;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70177_z += this.yaw;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70127_C += this.pitch;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70126_B += this.yaw;
            if (EntityTransformationStack.this.entity instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)EntityTransformationStack.this.entity;
                living.field_70759_as += this.yaw;
                living.field_70758_at += this.yaw;
            }
        }

        public void revert() {
            if (((EntityTransformationStack)EntityTransformationStack.this).entity.field_70170_p.field_72995_K) {
                this.revertClient();
            } else {
                this.revertMain();
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void revertClient() {
            EntityPlayerSP player;
            float prevYaw = 0.0f;
            float yaw = 0.0f;
            float prevPitch = 0.0f;
            float pitch = 0.0f;
            if (EntityTransformationStack.this.entity instanceof EntityPlayerSP) {
                player = (EntityPlayerSP)EntityTransformationStack.this.entity;
                prevYaw = player.field_70126_B - player.field_71163_h;
                yaw = player.field_70177_z - player.field_71154_f;
                prevPitch = player.field_70127_C - player.field_71164_i;
                pitch = player.field_70125_A - player.field_71155_g;
            }
            this.revertMain();
            if (EntityTransformationStack.this.entity instanceof EntityPlayerSP) {
                player = (EntityPlayerSP)EntityTransformationStack.this.entity;
                player.field_71163_h = player.field_70126_B;
                player.field_71154_f = player.field_70177_z;
                player.field_71164_i = player.field_70127_C;
                player.field_71155_g = player.field_70125_A;
                player.field_71163_h -= prevYaw;
                player.field_71154_f -= yaw;
                player.field_71164_i -= prevPitch;
                player.field_71155_g -= pitch;
            }
        }

        private void revertMain() {
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70165_t -= this.x;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70163_u -= this.y;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70161_v -= this.z;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70169_q -= this.x;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70167_r -= this.y;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70166_s -= this.z;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70142_S -= this.x;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70137_T -= this.y;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70136_U -= this.z;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70125_A -= this.pitch;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70177_z -= this.yaw;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70127_C -= this.pitch;
            ((EntityTransformationStack)EntityTransformationStack.this).entity.field_70126_B -= this.yaw;
            if (EntityTransformationStack.this.entity instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)EntityTransformationStack.this.entity;
                living.field_70759_as -= this.yaw;
                living.field_70758_at -= this.yaw;
            }
        }
    }
}

