/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockTorchWeb;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DirectionalPieceVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonConfigurationVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonStartVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.PieceVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.SizedPieceVenus;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class RoomBossVenus
extends SizedPieceVenus {
    private EnumFacing exitDirection;
    private BlockPos chestPos;

    public RoomBossVenus() {
    }

    public RoomBossVenus(DungeonConfigurationVenus configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        this(configuration, rand, blockPosX, blockPosZ, rand.nextInt(6) + 20, rand.nextInt(2) + 10, rand.nextInt(6) + 20, entranceDir);
    }

    public RoomBossVenus(DungeonConfigurationVenus configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, sizeX, sizeY, sizeZ, entranceDir.func_176734_d());
        this.func_186164_a(EnumFacing.SOUTH);
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.sizeY = sizeY;
        int yPos = configuration.getYPosition();
        this.field_74887_e = new StructureBoundingBox(blockPosX, yPos - 2, blockPosZ, blockPosX + this.sizeX, yPos + this.sizeY, blockPosZ + this.sizeZ);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        if (this.exitDirection != null) {
            tagCompound.func_74768_a("direction_exit", this.exitDirection.ordinal());
        }
        tagCompound.func_74757_a("chestPosNull", this.chestPos == null);
        if (this.chestPos != null) {
            tagCompound.func_74768_a("chestX", this.chestPos.func_177958_n());
            tagCompound.func_74768_a("chestY", this.chestPos.func_177956_o());
            tagCompound.func_74768_a("chestZ", this.chestPos.func_177952_p());
        }
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        super.func_143011_b(tagCompound, manager);
        this.exitDirection = tagCompound.func_74764_b("direction_exit") ? EnumFacing.func_82600_a((int)tagCompound.func_74762_e("direction_exit")) : null;
        if (tagCompound.func_74764_b("chestPosNull") && !tagCompound.func_74767_n("chestPosNull")) {
            this.chestPos = new BlockPos(tagCompound.func_74762_e("chestX"), tagCompound.func_74762_e("chestY"), tagCompound.func_74762_e("chestZ"));
        }
    }

    public boolean func_74875_a(World worldIn, Random random, StructureBoundingBox chunkBox) {
        StructureBoundingBox box = new StructureBoundingBox(new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE});
        for (int i = 0; i <= this.sizeX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeZ; ++k) {
                    double dX = i - this.sizeX / 2;
                    double dZ = k - this.sizeZ / 2;
                    double dXZ = Math.sqrt(dX * dX + dZ * dZ);
                    double f = -Math.pow(dXZ * 1.5 / (double)(this.sizeX / 2 - 1), 6.0) + (double)this.sizeY - 1.0;
                    if (j == 0) {
                        this.func_175811_a(worldIn, this.configuration.getBrickBlockFloor(), i, j, k, chunkBox);
                        continue;
                    }
                    if ((double)j < f) {
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, chunkBox);
                        if ((double)(j + 1) >= f && dXZ > 5.0 && random.nextInt(12) == 0) {
                            int distFromFloor = random.nextInt(5) + 2;
                            for (int j0 = j; j0 >= distFromFloor + 1; --j0) {
                                BlockTorchWeb.EnumWebType webType = j0 == distFromFloor + 1 ? BlockTorchWeb.EnumWebType.WEB_1 : BlockTorchWeb.EnumWebType.WEB_0;
                                this.func_175811_a(worldIn, VenusBlocks.torchWeb.func_176223_P().func_177226_a(BlockTorchWeb.WEB_TYPE, (Comparable)((Object)webType)), i, j0, k, chunkBox);
                            }
                        }
                        if (i < box.field_78897_a) {
                            box.field_78897_a = i;
                        }
                        if (i > box.field_78893_d) {
                            box.field_78893_d = i;
                        }
                        if (j < box.field_78895_b) {
                            box.field_78895_b = j;
                        }
                        if (j > box.field_78894_e) {
                            box.field_78894_e = j;
                        }
                        if (k < box.field_78896_c) {
                            box.field_78896_c = k;
                        }
                        if (k <= box.field_78892_f) continue;
                        box.field_78892_f = k;
                        continue;
                    }
                    boolean placeBlock = true;
                    int start = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
                    int end = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
                    if (i > start && i <= end && j < 5 && j > 2) {
                        if ((this.getDirection() == EnumFacing.SOUTH || this.exitDirection != null && this.exitDirection == EnumFacing.SOUTH) && k < 7) {
                            placeBlock = false;
                        }
                        if ((this.getDirection() == EnumFacing.NORTH || this.exitDirection != null && this.exitDirection == EnumFacing.NORTH) && k > this.sizeZ - 7) {
                            placeBlock = false;
                        }
                    }
                    start = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
                    end = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
                    if (k > start && k <= end && j < 5 && j > 2) {
                        if ((this.getDirection() == EnumFacing.EAST || this.exitDirection != null && this.exitDirection == EnumFacing.EAST) && i < 7) {
                            placeBlock = false;
                        }
                        if ((this.getDirection() == EnumFacing.WEST || this.exitDirection != null && this.exitDirection == EnumFacing.WEST) && i > this.sizeX - 7) {
                            placeBlock = false;
                        }
                    }
                    if (placeBlock) {
                        this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, chunkBox);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, chunkBox);
                }
            }
        }
        int spawnerX = this.sizeX / 2;
        int spawnerY = 1;
        int spawnerZ = this.sizeZ / 2;
        BlockPos blockpos = new BlockPos(this.func_74865_a(spawnerX, spawnerZ), this.func_74862_a(spawnerY), this.func_74873_b(spawnerX, spawnerZ));
        if (chunkBox.func_175898_b((Vec3i)blockpos)) {
            worldIn.func_180501_a(blockpos, VenusBlocks.bossSpawner.func_176223_P(), 2);
            TileEntityDungeonSpawner spawner = (TileEntityDungeonSpawner)worldIn.func_175625_s(blockpos);
            if (spawner != null) {
                if (box.func_78883_b() > 10000 || box.func_78882_c() > 10000 || box.func_78880_d() > 10000) {
                    GalacticraftPlanets.logger.error("Failed to set correct boss room size. This is a bug!", new Object[0]);
                } else {
                    spawner.setRoom(new Vector3(box.field_78897_a + this.field_74887_e.field_78897_a, box.field_78895_b + this.field_74887_e.field_78895_b, box.field_78896_c + this.field_74887_e.field_78896_c), new Vector3(box.field_78893_d - box.field_78897_a + 1, box.field_78894_e - box.field_78895_b + 1, box.field_78892_f - box.field_78896_c + 1));
                    spawner.setChestPos(this.chestPos);
                }
            }
        }
        return true;
    }

    public BlockPos getChestPos() {
        return this.chestPos;
    }

    public void setChestPos(BlockPos chestPos) {
        this.chestPos = chestPos;
    }

    @Override
    public PieceVenus getNextPiece(DungeonStartVenus startPiece, Random rand) {
        DirectionalPieceVenus corridor = (DirectionalPieceVenus)this.getCorridor(rand, startPiece, 10, true);
        this.exitDirection = corridor == null ? null : corridor.getDirection().func_176734_d();
        return corridor;
    }
}

