/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.miccore;

import java.io.File;
import micdoodle8.mods.miccore.MicdoodlePlugin;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigManagerMicCore {
    public static boolean loaded;
    static Configuration configuration;
    public static boolean enableDebug;

    public static void init() {
        File oldCoreConfig = new File(MicdoodlePlugin.canonicalConfigDir, "Galacticraft/miccore.conf");
        File coremodConfig = new File(MicdoodlePlugin.canonicalConfigDir, "Galacticraft/MicdoodleCore.cfg");
        if (!loaded) {
            if (oldCoreConfig.exists()) {
                configuration = ConfigManagerMicCore.handleConfigFileMove(new Configuration(oldCoreConfig), coremodConfig);
                oldCoreConfig.delete();
            } else {
                configuration = new Configuration(coremodConfig);
            }
        }
        configuration.load();
        ConfigManagerMicCore.syncConfig();
    }

    private static Configuration handleConfigFileMove(Configuration oldConfig, File newFile) {
        Property logDebugOutput = oldConfig.get("general", "Enable Debug messages", false);
        Configuration newConfig = new Configuration(newFile);
        newConfig.get("general", "logDebugOutput", logDebugOutput.getBoolean(), "If `true` Enable debug messages during Galacticraft bytecode injection at startup");
        newConfig.save();
        return newConfig;
    }

    public static void syncConfig() {
        try {
            enableDebug = configuration.get("general", "logDebugOutput", false, "If `true` Enable debug messages during Galacticraft bytecode injection at startup").getBoolean(false);
        }
        catch (Exception e) {
            MicdoodlePlugin.miccoreLogger.error("Problem loading core config (\"MicdoodleCore.conf\")");
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
            loaded = true;
        }
    }
}

