/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.flowpowered.math.vector.Vector3d;
import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.RegionEventType;
import com.universeguard.region.enums.RegionPermission;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.PermissionUtils;
import com.universeguard.utils.RegionUtils;
import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.property.block.MatterProperty;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagDestroyListener {
    @Listener
    public void onEntityDestroyed(InteractEntityEvent.Primary event, @First Player player) {
        Entity targetEntity = event.getTargetEntity();
        EntityType type = targetEntity.getType();
        if (FlagUtils.isBlockEntity(type) || targetEntity instanceof TileEntity) {
            this.handleEvent((Cancellable)event, (Location<World>)targetEntity.getLocation(), player);
        }
    }

    @Listener
    public void onBucketFill(InteractBlockEvent.Secondary event, @First Player player) {
        BlockState block;
        Optional matter;
        Optional item = event.getContext().get(EventContextKeys.USED_ITEM);
        if (item.isPresent() && ((ItemStackSnapshot)item.get()).getType().equals(ItemTypes.BUCKET) && event.getInteractionPoint().isPresent() && (matter = (block = player.getWorld().getBlock(((Vector3d)event.getInteractionPoint().get()).toInt())).getProperty(MatterProperty.class)).isPresent() && Objects.equals(((MatterProperty)matter.get()).getValue(), MatterProperty.Matter.LIQUID)) {
            this.handleEvent((Cancellable)event, (Location<World>)player.getLocation(), player);
        }
    }

    @Listener
    public void onEntityCollide(CollideEntityEvent.Impact event, @First Player player) {
        Entity targetEntity;
        EntityType type;
        if (!event.getEntities().isEmpty() && FlagUtils.isBlockEntity(type = (targetEntity = (Entity)event.getEntities().get(0)).getType())) {
            this.handleEvent((Cancellable)event, (Location<World>)targetEntity.getLocation(), player);
        }
    }

    @Listener
    public void onBlockDestroyedByPlayer(ChangeBlockEvent.Pre event) {
        if (event.getContext().containsKey(EventContextKeys.OWNER) || event.getContext().containsKey(EventContextKeys.PLAYER_BREAK)) {
            Optional item = event.getContext().get(EventContextKeys.USED_ITEM);
            event.getLocations().forEach(location -> {
                BlockState block = location.getBlock();
                Region region = RegionUtils.getRegion((Location<World>)location);
                Player player = event.getCause().first(Player.class).orElse(null);
                if (region != null && FlagUtils.isExcludedFromDestroy(region, block.getType()) && (player == null || !PermissionUtils.hasPermission(player, RegionPermission.REGION))) {
                    if (item.isPresent() && region.getDisallowedItems().contains(((ItemStackSnapshot)item.get()).getType().getId())) {
                        event.setCancelled(true);
                        MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                    } else if (region.getFlag(EnumRegionFlag.DESTROY)) {
                        event.setCancelled(true);
                        MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                    }
                } else {
                    this.handleEvent((Cancellable)event, (Location<World>)location, player);
                }
            });
        }
    }

    @Listener
    public void onBlockDestroyedByPlayer(ChangeBlockEvent.Break event) {
        if (!event.getTransactions().isEmpty()) {
            BlockSnapshot block = (BlockSnapshot)((Transaction)event.getTransactions().get(0)).getOriginal();
            BlockType type = block.getState().getType();
            if (block.getLocation().isPresent()) {
                Player player = event.getCause().first(Player.class).orElse(null);
                Region region = RegionUtils.getRegion((Location<World>)((Location)block.getLocation().get()));
                if (region != null && FlagUtils.isExcludedFromDestroy(region, type) && (player == null || !PermissionUtils.hasPermission(player, RegionPermission.REGION))) {
                    if (region.getFlag(EnumRegionFlag.DESTROY)) {
                        event.setCancelled(true);
                        MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                    }
                } else {
                    this.handleEvent((Cancellable)event, (Location<World>)((Location)block.getLocation().get()), player);
                }
            }
        }
    }

    private boolean handleEvent(Cancellable event, Location<World> location, Player player) {
        return RegionUtils.handleEvent(event, EnumRegionFlag.DESTROY, location, player, RegionEventType.LOCAL);
    }
}

