/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.region.components;

import com.flowpowered.math.vector.Vector3d;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class RegionLocation {
    private int x;
    private int y;
    private int z;
    private String dimension;
    private String world;

    public RegionLocation(int x, int y, int z, String dimension, String world) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setDimension(dimension);
        this.setWorld(world);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }

    public Vector3d toVector() {
        return new Vector3d((float)this.x, (float)this.y, (float)this.z);
    }

    public World getServerWorld() {
        return Sponge.getServer().getWorld(this.world).isPresent() ? (World)Sponge.getServer().getWorld(this.world).get() : null;
    }

    public Location<World> getLocation() {
        World world = this.getServerWorld();
        return world != null ? new Location((Extent)world, this.toVector()) : null;
    }
}

