/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour;

import WayofTime.bloodmagic.iface.IUpgradeTrainer;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourHandler;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.livingArmour.StatTracker;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class LivingArmour
implements ILivingArmour {
    public static String chatBase = "chat.bloodmagic.livingArmour.";
    public HashMap<String, StatTracker> trackerMap = new HashMap();
    public HashMap<String, LivingArmourUpgrade> upgradeMap = new HashMap();
    public int maxUpgradePoints = 100;
    public int totalUpgradePoints = 0;

    public StatTracker getTracker(String key) {
        return this.trackerMap.get(key);
    }

    public double getAdditionalDamageOnHit(double damage, EntityPlayer wearer, EntityLivingBase hitEntity, ItemStack weapon) {
        double total = 0.0;
        for (Map.Entry<String, LivingArmourUpgrade> entry : this.upgradeMap.entrySet()) {
            total += entry.getValue().getAdditionalDamageOnHit(damage, wearer, hitEntity, weapon);
        }
        return total;
    }

    public double getKnockbackOnHit(EntityPlayer wearer, EntityLivingBase hitEntity, ItemStack weapon) {
        double total = 0.0;
        for (Map.Entry<String, LivingArmourUpgrade> entry : this.upgradeMap.entrySet()) {
            total += entry.getValue().getKnockbackOnHit(wearer, hitEntity, weapon);
        }
        return total;
    }

    public void recalculateUpgradePoints() {
        this.totalUpgradePoints = 0;
        for (LivingArmourUpgrade upgrade : this.upgradeMap.values()) {
            this.totalUpgradePoints += upgrade.getCostOfUpgrade();
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers() {
        HashMultimap modifierMap = HashMultimap.create();
        for (Map.Entry<String, LivingArmourUpgrade> entry : this.upgradeMap.entrySet()) {
            LivingArmourUpgrade upgrade = entry.getValue();
            if (upgrade == null) continue;
            modifierMap.putAll(upgrade.getAttributeModifiers());
        }
        return modifierMap;
    }

    @Override
    public boolean upgradeArmour(EntityPlayer user, LivingArmourUpgrade upgrade) {
        String key = upgrade.getUniqueIdentifier();
        if (this.upgradeMap.containsKey(key)) {
            int upgradePointDifference;
            int currentLevel;
            int nextLevel = upgrade.getUpgradeLevel();
            if (nextLevel > (currentLevel = this.upgradeMap.get(key).getUpgradeLevel()) && this.totalUpgradePoints + (upgradePointDifference = upgrade.getCostOfUpgrade() - this.upgradeMap.get(key).getCostOfUpgrade()) <= this.maxUpgradePoints) {
                this.upgradeMap.put(key, upgrade);
                this.totalUpgradePoints += upgradePointDifference;
                this.notifyPlayerOfUpgrade(user, upgrade);
                for (StatTracker tracker : this.trackerMap.values()) {
                    tracker.onArmourUpgradeAdded(upgrade);
                }
                return true;
            }
        } else {
            int upgradePoints = upgrade.getCostOfUpgrade();
            if (this.totalUpgradePoints + upgradePoints <= this.maxUpgradePoints) {
                this.upgradeMap.put(key, upgrade);
                this.totalUpgradePoints += upgradePoints;
                this.notifyPlayerOfUpgrade(user, upgrade);
                for (StatTracker tracker : this.trackerMap.values()) {
                    tracker.onArmourUpgradeAdded(upgrade);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canApplyUpgrade(EntityPlayer user, LivingArmourUpgrade upgrade) {
        int upgradePoints;
        int upgradePointDifference;
        int currentLevel;
        int nextLevel;
        String key = upgrade.getUniqueIdentifier();
        return this.upgradeMap.containsKey(key) ? (nextLevel = upgrade.getUpgradeLevel()) > (currentLevel = this.upgradeMap.get(key).getUpgradeLevel()) && this.totalUpgradePoints + (upgradePointDifference = upgrade.getCostOfUpgrade() - this.upgradeMap.get(key).getCostOfUpgrade()) <= this.maxUpgradePoints : this.totalUpgradePoints + (upgradePoints = upgrade.getCostOfUpgrade()) <= this.maxUpgradePoints;
    }

    @Override
    public void notifyPlayerOfUpgrade(EntityPlayer user, LivingArmourUpgrade upgrade) {
        user.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localizeEffect(chatBase + "newUpgrade", new Object[0])), true);
    }

    @Override
    public void onTick(World world, EntityPlayer player) {
        for (Map.Entry<String, LivingArmourUpgrade> entry : this.upgradeMap.entrySet()) {
            LivingArmourUpgrade upgrade = entry.getValue();
            if (upgrade == null || world.field_72995_K && !upgrade.runOnClient()) continue;
            upgrade.onTick(world, player, this);
        }
        if (world.field_72995_K) {
            return;
        }
        ArrayList<String> allowedUpgradesList = new ArrayList<String>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            List<String> keyList;
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeTrainer) || (keyList = ((IUpgradeTrainer)stack.func_77973_b()).getTrainedUpgrades(stack)).isEmpty()) continue;
            allowedUpgradesList.addAll(keyList);
        }
        for (Map.Entry<String, StatTracker> entry : this.trackerMap.entrySet()) {
            StatTracker tracker = entry.getValue();
            if (tracker == null) continue;
            if (!allowedUpgradesList.isEmpty()) {
                boolean allowed = false;
                for (String key : allowedUpgradesList) {
                    if (!tracker.providesUpgrade(key)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    tracker.onDeactivatedTick(world, player, this);
                    continue;
                }
            }
            if (!tracker.onTick(world, player, this)) continue;
            List<LivingArmourUpgrade> upgradeList = tracker.getUpgrades();
            for (LivingArmourUpgrade upgrade : upgradeList) {
                this.upgradeArmour(player, upgrade);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.maxUpgradePoints = Math.max(100, tag.func_74762_e("maxUpgradePoints"));
        NBTTagList upgradeTags = tag.func_150295_c("upgrades", 10);
        if (upgradeTags != null) {
            for (int i = 0; i < upgradeTags.func_74745_c(); ++i) {
                NBTTagCompound nbtTag;
                int level;
                NBTTagCompound upgradeTag = upgradeTags.func_150305_b(i);
                String key = upgradeTag.func_74779_i("key");
                LivingArmourUpgrade upgrade = LivingArmourHandler.generateUpgradeFromKey(key, level = upgradeTag.func_74762_e("level"), nbtTag = upgradeTag.func_74775_l("upgrade"));
                if (upgrade == null) continue;
                this.upgradeMap.put(key, upgrade);
                this.totalUpgradePoints += upgrade.getCostOfUpgrade();
            }
        }
        for (Class<? extends StatTracker> clazz : LivingArmourHandler.trackers) {
            try {
                StatTracker tracker;
                String key;
                NBTTagCompound trackerTag;
                Constructor<? extends StatTracker> ctor = clazz.getConstructor(new Class[0]);
                StatTracker obj = ctor.newInstance(new Object[0]);
                if (!(obj instanceof StatTracker)) {
                    // empty if block
                }
                if (!(trackerTag = tag.func_74775_l(key = (tracker = obj).getUniqueIdentifier())).func_82582_d()) {
                    tracker.readFromNBT(trackerTag);
                }
                this.trackerMap.put(key, tracker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean forceWrite) {
        tag.func_74768_a("maxUpgradePoints", this.maxUpgradePoints);
        NBTTagList tags = new NBTTagList();
        for (Map.Entry<String, LivingArmourUpgrade> entry : this.upgradeMap.entrySet()) {
            NBTTagCompound upgradeTag = new NBTTagCompound();
            LivingArmourUpgrade upgrade = entry.getValue();
            NBTTagCompound nbtTag = new NBTTagCompound();
            upgrade.writeToNBT(nbtTag);
            upgradeTag.func_74778_a("key", upgrade.getUniqueIdentifier());
            upgradeTag.func_74768_a("level", upgrade.getUpgradeLevel());
            upgradeTag.func_74782_a("upgrade", (NBTBase)nbtTag);
            tags.func_74742_a((NBTBase)upgradeTag);
        }
        tag.func_74782_a("upgrades", (NBTBase)tags);
        for (Map.Entry<String, Object> entry : this.trackerMap.entrySet()) {
            StatTracker tracker = (StatTracker)entry.getValue();
            if (tracker == null) continue;
            String key = tracker.getUniqueIdentifier();
            if (!forceWrite && !tracker.isDirty()) continue;
            NBTTagCompound trackerTag = new NBTTagCompound();
            tracker.writeToNBT(trackerTag);
            tag.func_74782_a(key, (NBTBase)trackerTag);
            tracker.resetDirty();
        }
    }

    @Override
    public void writeDirtyToNBT(NBTTagCompound tag) {
        this.writeToNBT(tag, false);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        this.writeToNBT(tag, true);
    }

    @Override
    public boolean removeUpgrade(EntityPlayer user, LivingArmourUpgrade upgrade) {
        String key = upgrade.getUniqueIdentifier();
        if (this.upgradeMap.containsKey(key)) {
            this.upgradeMap.remove(key);
            return true;
        }
        return false;
    }

    public static boolean hasFullSet(EntityPlayer player) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack slotStack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !(slotStack = player.func_184582_a(slot)).func_190926_b() && slotStack.func_77973_b() instanceof ItemLivingArmour) continue;
            return false;
        }
        return true;
    }
}

