/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.AEApi;
import appeng.api.util.AEAxisAlignedBB;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.FacadeBlockAccess;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.client.render.cablebus.QuadRotator;
import appeng.parts.misc.PartCableAnchor;
import appeng.thirdparty.codechicken.lib.model.CachedFormat;
import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.BakedPipeline;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadAlphaOverride;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadClamper;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadCornerKicker;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadFaceStripper;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadReInterpolator;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadTinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class FacadeBuilder {
    public static final double THICK_THICKNESS = 0.125;
    public static final double THIN_THICKNESS = 0.0625;
    public static final AxisAlignedBB[] THICK_FACADE_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AxisAlignedBB[] THIN_FACADE_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private ThreadLocal<BakedPipeline> pipelines = ThreadLocal.withInitial(() -> BakedPipeline.builder().addElement("clamper", QuadClamper.FACTORY).addElement("face_stripper", QuadFaceStripper.FACTORY).addElement("corner_kicker", QuadCornerKicker.FACTORY).addElement("interp", QuadReInterpolator.FACTORY).addElement("tinter", QuadTinter.FACTORY, false).addElement("transparent", QuadAlphaOverride.FACTORY, false, e -> e.setAlphaOverride(0.29803923f)).build());
    private ThreadLocal<Quad> collectors = ThreadLocal.withInitial(Quad::new);

    public void buildFacadeQuads(BlockRenderLayer layer, CableBusRenderState renderState, long rand, List<BakedQuad> quads, Function<ResourceLocation, IBakedModel> modelLookup) {
        BakedPipeline pipeline = this.pipelines.get();
        Quad collectorQuad = this.collectors.get();
        boolean transparent = AEApi.instance().partHelper().getCableRenderMode().transparentFacades;
        EnumMap<EnumFacing, FacadeRenderState> facadeStates = renderState.getFacades();
        List<AxisAlignedBB> partBoxes = renderState.getBoundingBoxes();
        Set<EnumFacing> sidesWithParts = renderState.getAttachments().keySet();
        IBlockAccess parentWorld = renderState.getWorld();
        BlockPos pos = renderState.getPos();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        boolean thinFacades = FacadeBuilder.isUseThinFacades(partBoxes);
        for (Map.Entry entry : facadeStates.entrySet()) {
            AxisAlignedBB fullBounds;
            boolean renderStilt;
            EnumFacing side = (EnumFacing)entry.getKey();
            int sideIndex = side.ordinal();
            FacadeRenderState facadeRenderState = (FacadeRenderState)entry.getValue();
            boolean bl = renderStilt = !sidesWithParts.contains(side);
            if (layer == BlockRenderLayer.CUTOUT && renderStilt) {
                for (ResourceLocation part : PartCableAnchor.FACADE_MODELS.getModels()) {
                    IBakedModel partModel = modelLookup.apply(part);
                    QuadRotator rotator = new QuadRotator();
                    quads.addAll(rotator.rotateQuads(FacadeBuilder.gatherQuads(partModel, null, rand), side, EnumFacing.UP));
                }
            }
            if (transparent && layer != BlockRenderLayer.TRANSLUCENT) continue;
            IBlockState blockState = facadeRenderState.getSourceBlock();
            if (!transparent && layer != null && !blockState.func_177230_c().canRenderInLayer(blockState, layer)) continue;
            AxisAlignedBB facadeBox = fullBounds = thinFacades ? THIN_FACADE_BOXES[sideIndex] : THICK_FACADE_BOXES[sideIndex];
            if (facadeRenderState.isTransparent()) {
                double offset = thinFacades ? 0.0625 : 0.125;
                AEAxisAlignedBB tmpBB = null;
                block14: for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                    FacadeRenderState otherState;
                    if (enumFacing.func_176740_k() == side.func_176740_k() || (otherState = (FacadeRenderState)facadeStates.get(enumFacing)) == null || otherState.isTransparent()) continue;
                    if (tmpBB == null) {
                        tmpBB = AEAxisAlignedBB.fromBounds(facadeBox);
                    }
                    switch (enumFacing) {
                        case DOWN: {
                            tmpBB.minY += offset;
                            continue block14;
                        }
                        case UP: {
                            tmpBB.maxY -= offset;
                            continue block14;
                        }
                        case NORTH: {
                            tmpBB.minZ += offset;
                            continue block14;
                        }
                        case SOUTH: {
                            tmpBB.maxZ -= offset;
                            continue block14;
                        }
                        case WEST: {
                            tmpBB.minX += offset;
                            continue block14;
                        }
                        case EAST: {
                            tmpBB.maxX -= offset;
                            continue block14;
                        }
                        default: {
                            throw new RuntimeException("Switch falloff. " + String.valueOf(enumFacing));
                        }
                    }
                }
                if (tmpBB != null) {
                    facadeBox = tmpBB.getBoundingBox();
                }
            }
            AEAxisAlignedBB cutOutBox = FacadeBuilder.getCutOutBox(facadeBox, partBoxes);
            List<AxisAlignedBB> holeStrips = FacadeBuilder.getBoxes(facadeBox, cutOutBox, side.func_176740_k());
            FacadeBlockAccess facadeAccess = new FacadeBlockAccess(parentWorld, pos, side, blockState);
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            try {
                blockState = blockState.func_185899_b((IBlockAccess)facadeAccess, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IBakedModel model = dispatcher.func_184389_a(blockState);
            try {
                blockState = blockState.func_177230_c().getExtendedState(blockState, (IBlockAccess)facadeAccess, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<BakedQuad> modelQuads = new ArrayList<BakedQuad>();
            if (transparent || layer == null) {
                for (BlockRenderLayer forcedLayer : BlockRenderLayer.values()) {
                    if (!blockState.func_177230_c().canRenderInLayer(blockState, forcedLayer)) continue;
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)forcedLayer);
                    modelQuads.addAll(FacadeBuilder.gatherQuads(model, blockState, rand));
                }
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            } else {
                modelQuads.addAll(FacadeBuilder.gatherQuads(model, blockState, rand));
            }
            if (modelQuads.isEmpty()) continue;
            QuadClamper quadClamper = pipeline.getElement("clamper", QuadClamper.class);
            QuadFaceStripper edgeStripper = pipeline.getElement("face_stripper", QuadFaceStripper.class);
            QuadTinter tinter = pipeline.getElement("tinter", QuadTinter.class);
            QuadCornerKicker kicker = pipeline.getElement("corner_kicker", QuadCornerKicker.class);
            int facadeMask = 0;
            for (Map.Entry ent : facadeStates.entrySet()) {
                FacadeRenderState otherState;
                EnumFacing s = (EnumFacing)ent.getKey();
                if (s.func_176740_k() == side.func_176740_k() || (otherState = (FacadeRenderState)ent.getValue()).isTransparent()) continue;
                facadeMask |= 1 << s.ordinal();
            }
            edgeStripper.setBounds(fullBounds);
            edgeStripper.setMask(facadeMask);
            kicker.setSide(sideIndex);
            kicker.setFacadeMask(facadeMask);
            kicker.setBox(fullBounds);
            kicker.setThickness(thinFacades ? 0.0625 : 0.125);
            for (BakedQuad quad : modelQuads) {
                CachedFormat format = CachedFormat.lookup(quad.getFormat());
                if (quad.func_178212_b()) {
                    tinter.setTint(blockColors.func_186724_a(blockState, (IBlockAccess)facadeAccess, pos, quad.func_178211_c()));
                }
                for (AxisAlignedBB box : holeStrips) {
                    quadClamper.setClampBounds(box);
                    pipeline.reset(format);
                    collectorQuad.reset(format);
                    pipeline.setElementState("tinter", quad.func_178212_b());
                    pipeline.setElementState("transparent", transparent);
                    pipeline.prepare(collectorQuad);
                    quad.pipe((IVertexConsumer)pipeline);
                    if (!collectorQuad.full) continue;
                    quads.add(collectorQuad.bake());
                }
            }
        }
    }

    public List<BakedQuad> buildFacadeItemQuads(ItemStack textureItem, EnumFacing side) {
        ArrayList<BakedQuad> facadeQuads = new ArrayList<BakedQuad>();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(textureItem, null, null);
        List<BakedQuad> modelQuads = FacadeBuilder.gatherQuads(model, null, 0L);
        BakedPipeline pipeline = this.pipelines.get();
        Quad collectorQuad = this.collectors.get();
        QuadClamper clamper = pipeline.getElement("clamper", QuadClamper.class);
        QuadTinter tinter = pipeline.getElement("tinter", QuadTinter.class);
        for (BakedQuad quad : modelQuads) {
            CachedFormat format = CachedFormat.lookup(quad.getFormat());
            pipeline.reset(format);
            collectorQuad.reset(format);
            if (quad.func_178212_b()) {
                tinter.setTint(Minecraft.func_71410_x().getItemColors().func_186728_a(textureItem, quad.func_178211_c()));
                pipeline.enableElement("tinter");
            }
            pipeline.disableElement("face_stripper");
            pipeline.disableElement("corner_kicker");
            clamper.setClampBounds(THICK_FACADE_BOXES[side.ordinal()]);
            pipeline.prepare(collectorQuad);
            quad.pipe((IVertexConsumer)pipeline);
            if (!collectorQuad.full) continue;
            facadeQuads.add((BakedQuad)collectorQuad.bakeUnpacked());
        }
        return facadeQuads;
    }

    private static List<BakedQuad> gatherQuads(IBakedModel model, IBlockState state, long rand) {
        ArrayList<BakedQuad> modelQuads = new ArrayList<BakedQuad>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            modelQuads.addAll(model.func_188616_a(state, face, rand));
        }
        modelQuads.addAll(model.func_188616_a(state, null, rand));
        return modelQuads;
    }

    @Nullable
    private static AEAxisAlignedBB getCutOutBox(AxisAlignedBB facadeBox, List<AxisAlignedBB> partBoxes) {
        AEAxisAlignedBB b = null;
        for (AxisAlignedBB bb : partBoxes) {
            if (!bb.func_72326_a(facadeBox)) continue;
            if (b == null) {
                b = AEAxisAlignedBB.fromBounds(bb);
                continue;
            }
            b.maxX = Math.max(b.maxX, bb.field_72336_d);
            b.maxY = Math.max(b.maxY, bb.field_72337_e);
            b.maxZ = Math.max(b.maxZ, bb.field_72334_f);
            b.minX = Math.min(b.minX, bb.field_72340_a);
            b.minY = Math.min(b.minY, bb.field_72338_b);
            b.minZ = Math.min(b.minZ, bb.field_72339_c);
        }
        return b;
    }

    private static List<AxisAlignedBB> getBoxes(AxisAlignedBB fb, AEAxisAlignedBB hole, EnumFacing.Axis axis) {
        if (hole == null) {
            return Collections.singletonList(fb);
        }
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        switch (axis) {
            case Y: {
                boxes.add(new AxisAlignedBB(fb.field_72340_a, fb.field_72338_b, fb.field_72339_c, hole.minX, fb.field_72337_e, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(hole.maxX, fb.field_72338_b, fb.field_72339_c, fb.field_72336_d, fb.field_72337_e, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(hole.minX, fb.field_72338_b, fb.field_72339_c, hole.maxX, fb.field_72337_e, hole.minZ));
                boxes.add(new AxisAlignedBB(hole.minX, fb.field_72338_b, hole.maxZ, hole.maxX, fb.field_72337_e, fb.field_72334_f));
                break;
            }
            case Z: {
                boxes.add(new AxisAlignedBB(fb.field_72340_a, fb.field_72338_b, fb.field_72339_c, fb.field_72336_d, hole.minY, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.maxY, fb.field_72339_c, fb.field_72336_d, fb.field_72337_e, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.minY, fb.field_72339_c, hole.minX, hole.maxY, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(hole.maxX, hole.minY, fb.field_72339_c, fb.field_72336_d, hole.maxY, fb.field_72334_f));
                break;
            }
            case X: {
                boxes.add(new AxisAlignedBB(fb.field_72340_a, fb.field_72338_b, fb.field_72339_c, fb.field_72336_d, hole.minY, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.maxY, fb.field_72339_c, fb.field_72336_d, fb.field_72337_e, fb.field_72334_f));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.minY, fb.field_72339_c, fb.field_72336_d, hole.maxY, hole.minZ));
                boxes.add(new AxisAlignedBB(fb.field_72340_a, hole.minY, hole.maxZ, fb.field_72336_d, hole.maxY, fb.field_72334_f));
                break;
            }
            default: {
                throw new RuntimeException("switch falloff. " + String.valueOf(axis));
            }
        }
        return boxes;
    }

    private static boolean isUseThinFacades(List<AxisAlignedBB> partBoxes) {
        double min = 0.125;
        double max = 0.875;
        for (AxisAlignedBB bb : partBoxes) {
            int o = 0;
            o += bb.field_72336_d > 0.875 ? 1 : 0;
            o += bb.field_72337_e > 0.875 ? 1 : 0;
            o += bb.field_72334_f > 0.875 ? 1 : 0;
            o += bb.field_72340_a < 0.125 ? 1 : 0;
            o += bb.field_72338_b < 0.125 ? 1 : 0;
            if ((o += bb.field_72339_c < 0.125 ? 1 : 0) < 2) continue;
            return true;
        }
        return false;
    }
}

