/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block.entity;

import fossilsarcheology.Revival;
import fossilsarcheology.server.block.FeederBlock;
import fossilsarcheology.server.entity.prehistoric.Diet;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.message.MessageUpdateFeeder;
import fossilsarcheology.server.util.FoodMappings;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityFeeder
extends TileEntity
implements IInventory,
ISidedInventory,
ITickable {
    private static final int[] SLOTS_TOP = new int[]{0, 1};
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private int meat;
    private int plant;
    private int prevMeat;
    private int prevPlant;
    private int ticksExisted;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private String customName;

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return ItemStackHelper.func_188382_a(this.stacks, (int)slot, (int)amount);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.stacks);
        this.meat = compound.func_74762_e("Meat");
        this.plant = compound.func_74762_e("Plant");
        if (compound.func_74764_b("CustomName")) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("Meat", this.meat);
        compound.func_74768_a("Plant", this.plant);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return FoodMappings.INSTANCE.getItemFoodAmount(stack, Diet.CARNIVORE_EGG) > 0 || FoodMappings.INSTANCE.getItemFoodAmount(stack, Diet.PISCCARNIVORE) > 0;
        }
        if (slot == 1) {
            return FoodMappings.INSTANCE.getItemFoodAmount(stack, Diet.HERBIVORE) > 0;
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.meat;
            }
            case 1: {
                return this.plant;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.meat = value;
                break;
            }
            case 1: {
                this.plant = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        return side != EnumFacing.DOWN ? SLOTS_TOP : new int[]{};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.DOWN;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : I18n.func_74838_a((String)"tile.feeder.name");
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager netManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean isEmpty(PrehistoricEntityType type) {
        if (type.diet == Diet.CARNIVORE || type.diet == Diet.CARNIVORE_EGG || type.diet == Diet.PISCCARNIVORE || type.diet == Diet.PISCIVORE || type.diet == Diet.INSECTIVORE) {
            return this.meat == 0;
        }
        if (type.diet == Diet.HERBIVORE) {
            return this.plant == 0;
        }
        return type.diet == Diet.OMNIVORE && this.meat == 0 && this.meat == 0;
    }

    public int feedDinosaur(EntityPrehistoric mob) {
        int feedamount = 0;
        if (!this.isEmpty(mob.type)) {
            if (mob.type.diet == Diet.CARNIVORE || mob.type.diet == Diet.CARNIVORE_EGG || mob.type.diet == Diet.PISCCARNIVORE || mob.type.diet == Diet.PISCIVORE || mob.type.diet == Diet.INSECTIVORE) {
                --this.meat;
                this.field_145850_b.func_72960_a((Entity)mob, (byte)47);
                ++feedamount;
            }
            if (mob.type.diet == Diet.HERBIVORE) {
                --this.plant;
                this.field_145850_b.func_72960_a((Entity)mob, (byte)45);
                ++feedamount;
            }
            if (mob.type.diet == Diet.OMNIVORE) {
                if (this.meat == 0 && this.plant != 0) {
                    --this.meat;
                    ++feedamount;
                } else if (this.meat != 0 && this.plant == 0) {
                    --this.meat;
                    ++feedamount;
                } else if (this.meat != 0) {
                    --this.meat;
                    ++feedamount;
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateFeeder(this.field_174879_c.func_177986_g(), this.meat, this.plant));
        }
        FeederBlock.updateFeederBlockState(this.plant > 0, this.meat > 0, this.field_145850_b, this.func_174877_v());
        mob.setHunger(mob.getHunger() + feedamount);
        return feedamount;
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        this.prevMeat = this.meat;
        this.prevPlant = this.plant;
        this.meat = Math.max(this.meat, 0);
        this.plant = Math.max(this.plant, 0);
        if (!this.field_145850_b.field_72995_K) {
            int foodPoints;
            if (!this.func_70301_a(0).func_190926_b() && this.func_94041_b(0, this.func_70301_a(0)) && this.ticksExisted % 5 == 0 && this.meat < 10000 && (foodPoints = FoodMappings.INSTANCE.getItemFoodAmount(this.func_70301_a(0), Diet.CARNIVORE_EGG)) > 0) {
                this.meat += foodPoints;
                this.func_70298_a(0, 1);
            }
            if (!this.func_70301_a(0).func_190926_b() && this.func_94041_b(0, this.func_70301_a(0)) && this.ticksExisted % 5 == 0 && this.meat < 10000 && (foodPoints = FoodMappings.INSTANCE.getItemFoodAmount(this.func_70301_a(0), Diet.PISCIVORE)) > 0) {
                this.meat += foodPoints;
                this.func_70298_a(0, 1);
            }
            if (!this.func_70301_a(1).func_190926_b() && this.func_94041_b(1, this.func_70301_a(1)) && this.ticksExisted % 5 == 0 && this.plant < 10000 && (foodPoints = FoodMappings.INSTANCE.getItemFoodAmount(this.func_70301_a(1), Diet.HERBIVORE)) > 0) {
                this.plant += foodPoints;
                this.func_70298_a(1, 1);
            }
            if (this.prevMeat != this.meat || this.prevPlant != this.plant) {
                FeederBlock.updateFeederBlockState(this.plant > 0, this.meat > 0, this.field_145850_b, this.func_174877_v());
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public int getMeatBarScaled(int i) {
        return this.func_174887_a_(0) * i / 10000;
    }

    public int getVegBarScaled(int i) {
        return this.func_174887_a_(1) * i / 10000;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handlerTop;
        }
        return (T)super.getCapability(capability, facing);
    }
}

