/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.ai;

import fossilsarcheology.server.entity.FoodHelper;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricFlying;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricSwimming;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.entity.prehistoric.PrehistoricMoodType;
import fossilsarcheology.server.entity.utility.EntityToyBase;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;

public class DinoAIHunt<T extends EntityLivingBase>
extends EntityAINearestAttackableTarget<T> {
    private final EntityPrehistoric dino;

    public DinoAIHunt(EntityPrehistoric entityIn, Class<T> classTarget, boolean checkSight, Predicate<? super T> targetSelector) {
        super((EntityCreature)entityIn, classTarget, 0, checkSight, true, targetSelector::test);
        this.dino = entityIn;
    }

    public boolean func_75250_a() {
        if (this.dino.func_184207_aI() || this.dino.isMovementBlockedSoft()) {
            return false;
        }
        if (super.func_75250_a() && this.field_75309_a != null && !this.field_75309_a.getClass().equals(this.dino.getClass())) {
            if (this.field_75309_a instanceof EntityToyBase && this.dino.ticksTillPlay == 0) {
                return true;
            }
            double targetWidth = this.field_75309_a.field_70130_N;
            if (this.field_75309_a.func_174813_aQ() != null) {
                targetWidth = this.field_75309_a.func_174813_aQ().func_72320_b();
            }
            if ((this.dino.func_174813_aQ().func_72320_b() * (double)this.dino.getTargetScale() >= targetWidth || (this.dino.getMoodFace() == PrehistoricMoodType.ANGRY || this.dino.getMoodFace() == PrehistoricMoodType.SAD) && this.field_75309_a instanceof EntityPlayer) && !this.dino.isMovementBlockedSoft()) {
                if (this.field_75309_a instanceof EntityPlayer && ((EntityPlayer)this.field_75309_a).func_184812_l_()) {
                    return false;
                }
                if (this.field_75309_a instanceof EntityPlayer) {
                    if (this.dino.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                        return false;
                    }
                    if (this.dino.getMoodFace() == PrehistoricMoodType.ANGRY || this.dino.getMoodFace() == PrehistoricMoodType.SAD && !this.dino.func_152114_e(this.field_75309_a)) {
                        return true;
                    }
                    if (this.dino.getMood() > 25 && this.dino.getMoodFace() != PrehistoricMoodType.CALM) {
                        return false;
                    }
                    return !this.dino.func_152114_e(this.field_75309_a) && this.dino.canDinoHunt((Entity)this.field_75309_a, true);
                }
                if (FoodHelper.getMobFoodPoints(this.field_75309_a, this.dino.type.diet) > 0 || this.dino.aiResponseType() == PrehistoricEntityTypeAI.Response.AGRESSIVE) {
                    return !this.dino.func_152114_e(this.field_75309_a) && this.dino.canDinoHunt((Entity)this.field_75309_a, true);
                }
                return this.field_75309_a instanceof EntityToyBase && this.dino.ticksTillPlay == 0 && this.dino.getMood() < 100;
            }
        }
        return false;
    }

    protected AxisAlignedBB func_188511_a(double targetDistance) {
        double yDist = 4.0;
        if (this.dino instanceof EntityPrehistoricFlying) {
            yDist = targetDistance;
        } else if (this.dino instanceof EntityPrehistoricSwimming) {
            yDist = ((EntityPrehistoricSwimming)this.dino).doesBreachAttack() ? 50.0 : targetDistance;
        }
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, yDist, targetDistance);
    }
}

