/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.event;

import com.google.common.base.Predicate;
import fossilsarcheology.Revival;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.FossilBlock;
import fossilsarcheology.server.entity.ai.AnimalAIFearDinosaur;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.EntityQuagga;
import fossilsarcheology.server.entity.prehistoric.IScaryDinosaur;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.utility.FossilsMammalProperties;
import fossilsarcheology.server.entity.utility.FossilsPlayerProperties;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.item.enchantment.FAEnchantmentRegistry;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.entity.EntityProperties;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FossilLivingEvent {
    public static final UUID ALEX_UUID = UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c");
    private static final Predicate ANIMAL_FEAR_DINOSAUR = new Predicate<EntityLivingBase>(){

        public boolean apply(@Nullable EntityLivingBase entity) {
            return entity != null && entity instanceof IScaryDinosaur;
        }
    };

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        FossilsPlayerProperties properties = (FossilsPlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getPlayer(), FossilsPlayerProperties.class);
        if (event.getWorld().field_73011_w.getDimension() == Revival.CONFIG_OPTIONS.dimensionIDDarknessLair && !this.isBreakableInAnuLair(event.getState()) && event.getState().func_177230_c() != Blocks.field_150343_Z && event.getState().func_177230_c() != FABlockRegistry.FAKE_OBSIDIAN && properties != null && !properties.killedAnu) {
            event.getPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("anu.breakblock", new Object[0]), true);
            event.setCanceled(true);
        }
        if (properties != null && properties.killedBiofossilCooldown > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGatherBlockDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getState().func_177230_c() == FABlockRegistry.FOSSIL && event.getHarvester() != null && event.getHarvester().func_184614_ca() != null) {
            ItemStack pickaxe = event.getHarvester().func_184614_ca();
            int arch_level = EnchantmentHelper.func_77506_a((Enchantment)FAEnchantmentRegistry.ENCHANTMENT_ARCHEOLOGY, (ItemStack)pickaxe);
            int paleo_level = EnchantmentHelper.func_77506_a((Enchantment)FAEnchantmentRegistry.ENCHANTMENT_PALEONTOLOGY, (ItemStack)pickaxe);
            if (arch_level != 0 || paleo_level != 0) {
                event.getDrops().clear();
                ItemStack newDrop = FossilBlock.getItemDroppedWithEnchants(event.getState(), new Random(), 1 + paleo_level, 1 + arch_level).func_77946_l();
                event.getDrops().add(newDrop);
            }
        }
    }

    private boolean isBreakableInAnuLair(IBlockState state) {
        return state.func_177230_c().func_149739_a().toLowerCase().contains("grave");
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() != null && this.isLivestock(event.getEntity()) && event.getEntity() instanceof EntityCreature && Revival.CONFIG_OPTIONS.animalsFearDinosaurs) {
            EntityCreature animal = (EntityCreature)event.getEntity();
            animal.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimalAIFearDinosaur(animal, EntityLivingBase.class, (Predicate<EntityLivingBase>)ANIMAL_FEAR_DINOSAUR, 12.0f, 1.2, 1.5));
        }
    }

    private boolean isLivestock(Entity entity) {
        String className = "";
        try {
            className = entity.getClass().getSimpleName();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return !className.isEmpty() && (entity instanceof EntityCow || entity instanceof EntitySheep || entity instanceof EntityPig || entity instanceof EntityChicken || entity instanceof EntityRabbit || entity instanceof AbstractHorse || className.contains("Cow") || className.contains("Sheep") || className.contains("Pig") || className.contains("Chicken") || className.contains("Rabbit") || className.contains("Peacock") || className.contains("Goat") || className.contains("Ferret") || className.contains("Hedgehog") || className.contains("Peahen") || className.contains("Peafowl") || className.contains("Sow") || className.contains("Hog") || className.contains("Hog"));
    }

    @SubscribeEvent
    public void entityInteractEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        FossilsMammalProperties properties;
        if (event.getItemStack().func_77973_b() == FAItemRegistry.DINOPEDIA && event.getTarget() instanceof EntityAnimal && (properties = (FossilsMammalProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getTarget(), FossilsMammalProperties.class)) != null && properties.isPregnant()) {
            Revival.PEDIA_OBJECT = event.getTarget();
            Revival.PROXY.openPedia();
        }
    }

    @SubscribeEvent
    public void onEntityLiving(LivingEvent.LivingUpdateEvent event) {
        EntityProperties properties;
        if (event.getEntityLiving() instanceof EntityPlayer) {
            try {
                properties = (FossilsPlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), FossilsPlayerProperties.class);
                if (properties != null && properties.killedBiofossilCooldown > 0) {
                    --properties.killedBiofossilCooldown;
                }
            }
            catch (Exception e) {
                Revival.LOGGER.warn("could not instantiate fossils player properties for " + event.getEntityLiving().func_70005_c_());
            }
        }
        if (!event.getEntityLiving().func_70631_g_()) {
            try {
                properties = (FossilsMammalProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), FossilsMammalProperties.class);
                if (properties != null && properties.embryo != null) {
                    ++properties.embryoProgress;
                    if (properties.embryoProgress >= Revival.CONFIG_OPTIONS.pregnancyTime) {
                        this.growEntity(properties.embryo, event);
                        properties.embryoProgress = 0;
                        properties.embryo = null;
                    }
                }
            }
            catch (Exception e) {
                Revival.LOGGER.warn("could not instantiate fossils entity properties for " + event.getEntityLiving().func_70005_c_());
            }
        }
    }

    public void growEntity(PrehistoricEntityType embryo, LivingEvent.LivingUpdateEvent event) {
        EntityDonkey entityHorse;
        float rnd = new Random().nextInt(100);
        EntityLivingBase entity = event.getEntityLiving();
        Entity birthEntity = embryo.invokeClass(entity.field_70170_p);
        if (embryo == PrehistoricEntityType.DONKEY) {
            if (entity instanceof EntityDonkey) {
                if (rnd < 5.0f) {
                    birthEntity = new EntityDonkey(entity.field_70170_p);
                    if (((AbstractHorse)entity).func_184780_dh() != null) {
                        ((EntityDonkey)birthEntity).func_184779_b(((AbstractHorse)entity).func_184780_dh());
                        ((EntityDonkey)birthEntity).func_110234_j(true);
                    }
                } else if (rnd < 10.0f) {
                    birthEntity = new EntityDonkey(entity.field_70170_p);
                    if (((AbstractHorse)entity).func_184780_dh() != null) {
                        ((EntityDonkey)birthEntity).func_184779_b(((AbstractHorse)entity).func_184780_dh());
                        ((EntityDonkey)birthEntity).func_110234_j(true);
                    }
                } else {
                    birthEntity = ((EntityDonkey)entity).func_90011_a((EntityAgeable)new EntityDonkey(entity.field_70170_p));
                }
            } else {
                entityHorse = new EntityDonkey(entity.field_70170_p);
                birthEntity = entityHorse.func_90011_a((EntityAgeable)new EntityDonkey(entity.field_70170_p));
            }
        }
        if (embryo == PrehistoricEntityType.HORSE) {
            if (entity instanceof EntityHorse) {
                if (rnd < 5.0f) {
                    birthEntity = new EntityHorse(entity.field_70170_p);
                    ((EntityHorse)birthEntity).func_110235_q(3);
                    if (((AbstractHorse)entity).func_184780_dh() != null) {
                        ((EntityHorse)birthEntity).func_184779_b(((AbstractHorse)entity).func_184780_dh());
                        ((EntityHorse)birthEntity).func_110234_j(true);
                    }
                } else if (rnd < 10.0f) {
                    birthEntity = new EntityHorse(entity.field_70170_p);
                    ((EntityHorse)birthEntity).func_110235_q(4);
                    if (((AbstractHorse)entity).func_184780_dh() != null) {
                        ((EntityHorse)birthEntity).func_184779_b(((AbstractHorse)entity).func_184780_dh());
                        ((EntityHorse)birthEntity).func_110234_j(true);
                    }
                } else {
                    birthEntity = ((EntityHorse)entity).func_90011_a((EntityAgeable)new EntityHorse(entity.field_70170_p));
                }
            } else {
                entityHorse = new EntityHorse(entity.field_70170_p);
                birthEntity = entityHorse.func_90011_a((EntityAgeable)new EntityHorse(entity.field_70170_p));
            }
        }
        if (embryo == PrehistoricEntityType.LLAMA) {
            if (entity instanceof EntityLlama) {
                if (rnd < 5.0f) {
                    birthEntity = new EntityLlama(entity.field_70170_p);
                    if (((AbstractHorse)entity).func_184780_dh() != null) {
                        ((EntityLlama)birthEntity).func_184779_b(((AbstractHorse)entity).func_184780_dh());
                        ((EntityLlama)birthEntity).func_110234_j(true);
                    }
                } else if (rnd < 10.0f) {
                    birthEntity = new EntityLlama(entity.field_70170_p);
                    if (((AbstractHorse)entity).func_184780_dh() != null) {
                        ((EntityLlama)birthEntity).func_184779_b(((AbstractHorse)entity).func_184780_dh());
                        ((EntityLlama)birthEntity).func_110234_j(true);
                    }
                } else {
                    birthEntity = ((EntityLlama)entity).func_90011_a((EntityAgeable)new EntityLlama(entity.field_70170_p));
                }
            } else {
                entityHorse = new EntityLlama(entity.field_70170_p);
                entityHorse.func_190710_o(entityHorse.func_70681_au().nextInt(4));
                birthEntity = entityHorse;
            }
        }
        if (birthEntity instanceof EntityPrehistoric && entity.field_70170_p.func_72890_a((Entity)entity, 15.0) != null) {
            ((EntityPrehistoric)birthEntity).func_70903_f(true);
            ((EntityPrehistoric)birthEntity).func_184754_b(entity.field_70170_p.func_72890_a((Entity)entity, 15.0).func_110124_au());
        }
        if (birthEntity instanceof EntityQuagga) {
            int d0 = (int)(entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + ((EntityQuagga)birthEntity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)((int)((EntityQuagga)birthEntity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b()));
            ((EntityQuagga)birthEntity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)d0 / 3.0);
            double d2 = entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + ((EntityQuagga)birthEntity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + ((EntityQuagga)birthEntity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
            ((EntityQuagga)birthEntity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d2 / 3.0);
        }
        if (birthEntity instanceof EntityPrehistoric) {
            ((EntityPrehistoric)birthEntity).setGender(new Random().nextInt(2));
            ((EntityPrehistoric)birthEntity).setAgeinTicks(0);
            ((EntityPrehistoric)birthEntity).setAgeInDays(0);
        } else if (birthEntity instanceof EntityAnimal) {
            ((EntityAnimal)birthEntity).func_70873_a(-24000);
        }
        birthEntity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        for (int var3 = 0; var3 < 7; ++var3) {
            double var4 = event.getEntityLiving().func_70681_au().nextGaussian() * 0.02;
            double var6 = event.getEntityLiving().func_70681_au().nextGaussian() * 0.02;
            double var8 = event.getEntityLiving().func_70681_au().nextGaussian() * 0.02;
            entity.field_70170_p.func_175688_a(EnumParticleTypes.HEART, entity.field_70165_t + (double)(event.getEntityLiving().func_70681_au().nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, entity.field_70163_u + 0.5 + (double)(event.getEntityLiving().func_70681_au().nextFloat() * entity.field_70131_O), entity.field_70161_v + (double)(event.getEntityLiving().func_70681_au().nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, var4, var6, var8, new int[0]);
        }
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_72838_d(birthEntity);
        }
    }

    @SubscribeEvent
    public void onEntityDie(LivingDeathEvent event) {
        if (event.getEntityLiving().func_110124_au().equals(ALEX_UUID)) {
            event.getEntityLiving().func_70099_a(new ItemStack((Item)FAItemRegistry.PINKERTON), 1.0f);
        }
    }
}

