/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import net.minecraft.entity.player.InventoryPlayer;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.MainPlayerInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.HotbarLens;
import org.spongepowered.common.item.inventory.lens.comp.MainPlayerInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.HotbarLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class MainPlayerInventoryLensImpl
extends GridInventoryLensImpl
implements MainPlayerInventoryLens {
    private static final int MAIN_INVENTORY_HEIGHT = 3;
    private static final int INVENTORY_WIDTH = 9;
    private HotbarLensImpl hotbar;
    private GridInventoryLensImpl grid;
    private boolean isContainer;

    public MainPlayerInventoryLensImpl(int base, SlotProvider slots, boolean isContainer) {
        super(base, 9, 4, MainPlayerInventoryAdapter.class, slots);
        this.isContainer = isContainer;
        this.lateInit(slots);
    }

    @Override
    protected void init(SlotProvider slots) {
    }

    private void lateInit(SlotProvider slots) {
        int base = this.base;
        int hotbarSize = InventoryPlayer.func_70451_h();
        if (this.isContainer) {
            this.grid = new GridInventoryLensImpl(base, 9, 3, slots);
            this.hotbar = new HotbarLensImpl((base += 27) - (hotbarSize - 9), hotbarSize, slots);
            this.addSpanningChild(this.grid, new InventoryProperty[0]);
            this.addSpanningChild(this.hotbar, new InventoryProperty[0]);
        } else {
            this.hotbar = new HotbarLensImpl(base, hotbarSize, slots);
            this.grid = new GridInventoryLensImpl(base += 9, 9, 3, slots);
            this.addSpanningChild(this.hotbar, new InventoryProperty[0]);
            this.addSpanningChild(this.grid, new InventoryProperty[0]);
            ShiftedSlotProvider shiftedSlotProvider = new ShiftedSlotProvider(slots, 9, 36);
        }
        this.cache();
    }

    @Override
    protected void init(SlotProvider slots, boolean spanning) {
    }

    @Override
    public InventoryAdapter getAdapter(Fabric fabric, Inventory parent) {
        return new MainPlayerInventoryAdapter(fabric, this, parent);
    }

    @Override
    public HotbarLens getHotbar() {
        return this.hotbar;
    }

    @Override
    public GridInventoryLens getGrid() {
        return this.grid;
    }

    private class ShiftedSlotProvider
    implements SlotProvider {
        private final SlotProvider provider;
        private final int shiftBy;
        private final int shiftAt;

        public ShiftedSlotProvider(SlotProvider provider, int shiftBy, int shiftAt) {
            this.provider = provider;
            this.shiftBy = shiftBy;
            this.shiftAt = shiftAt;
        }

        @Override
        public SlotLens getSlot(int index) {
            if ((index += this.shiftBy) >= this.shiftAt) {
                index -= this.shiftAt;
            }
            return this.provider.getSlot(index);
        }
    }
}

