/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.explosive.fireball.LargeFireball;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.bridge.entity.item.EntityLargeFireballBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.projectile.EntityFireballMixin;

@Mixin(value={EntityLargeFireball.class})
public abstract class EntityLargeFireballMixin
extends EntityFireballMixin
implements EntityLargeFireballBridge,
ExplosiveBridge {
    @Shadow
    public int field_92057_e;

    @Override
    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;"))
    @Nullable
    public net.minecraft.world.Explosion bridge$throwExplosionEventAndExplode(World worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean flaming, boolean smoking) {
        boolean griefer = ((GrieferBridge)((Object)this)).bridge$CanGrief();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.THROWER, ((LargeFireball)((Object)this)).getShooter());
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, ((LargeFireball)((Object)this)).getShooter());
            frame.pushCause(((Projectile)((Object)this)).getShooter());
            Optional<net.minecraft.world.Explosion> ex = SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).sourceExplosive((LargeFireball)((Object)this)).radius(strength).canCauseFire(flaming && griefer).shouldPlaySmoke(smoking && griefer).shouldBreakBlocks(smoking && griefer));
            net.minecraft.world.Explosion explosion = ex.orElse(null);
            return explosion;
        }
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.field_92057_e);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.field_92057_e = radius == null ? 1 : radius;
    }
}

