/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.nbt;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;

@Mixin(value={NBTTagCompound.class})
public abstract class NBTTagCompoundMixin
extends NBTBase {
    @Shadow
    @Final
    private Map<String, NBTBase> field_74784_a;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Redirect(method={"copy"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTBase;copy()Lnet/minecraft/nbt/NBTBase;"))
    @Nullable
    private NBTBase onTagCopy(@Nullable NBTBase base) {
        try {
            if (base == null) {
                return null;
            }
            NBTBase nBTBase = base.func_74737_b();
            return nBTBase;
        }
        catch (StackOverflowError e) {
            PrettyPrinter printer = new PrettyPrinter(60).add("StackOverflow from trying to copy this compound").centre().hr();
            printer.addWrapped(70, "Sponge caught a stack overflow error, printing out some special handling and printouts to assist in finding out where this recursion is coming from.", new Object[0]);
            printer.add();
            try {
                printer.addWrapped(80, "%s : %s", new Object[]{"This compound", this});
            }
            catch (Throwable error) {
                printer.addWrapped(80, "Unable to get the string of this compound. Printing out some of the entries to better assist", new Object[0]);
                for (Map.Entry<String, NBTBase> entry : this.field_74784_a.entrySet()) {
                    try {
                        printer.addWrapped(80, "%s : %s", entry.getKey(), entry.getValue());
                    }
                    catch (Throwable throwable) {
                        printer.add();
                        printer.addWrapped(80, "The offending key entry is belonging to " + entry.getKey(), new Object[0]);
                        break;
                    }
                }
            }
            printer.add();
            printer.log(SpongeImpl.getLogger(), Level.ERROR);
            return null;
        }
    }

    @Redirect(method={"copy"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;setTag(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V"))
    private void onCopySet(NBTTagCompound compound, String string, @Nullable NBTBase base) {
        if (base == null) {
            IllegalStateException exception = new IllegalStateException("There is a null NBTBase in the compound for key: " + string);
            SpongeImpl.getLogger().error("Printing out a stacktrace to catch an exception in performing an NBTTagCompound.copy!\nIf you are seeing this, then Sponge is preventing an exception from being thrown due to unforseen\npossible bugs in any mods present. Please report this to SpongePowered and/or the relative mod\nauthors for the offending compound data!", (Throwable)exception);
        } else {
            compound.func_74782_a(string, base);
        }
    }
}

