/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.data.type.NotePitches;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeNotePitch;

public final class NotePitchRegistryModule
implements CatalogRegistryModule<NotePitch> {
    private static final Map<Byte, SpongeNotePitch> pitchMappings = ImmutableMap.builder().put((Object)0, (Object)new SpongeNotePitch(0, "F_SHARP0")).put((Object)1, (Object)new SpongeNotePitch(1, "G0")).put((Object)2, (Object)new SpongeNotePitch(2, "G_SHARP0")).put((Object)3, (Object)new SpongeNotePitch(3, "A1")).put((Object)4, (Object)new SpongeNotePitch(4, "A_SHARP1")).put((Object)5, (Object)new SpongeNotePitch(5, "B1")).put((Object)6, (Object)new SpongeNotePitch(6, "C1")).put((Object)7, (Object)new SpongeNotePitch(7, "C_SHARP1")).put((Object)8, (Object)new SpongeNotePitch(8, "D1")).put((Object)9, (Object)new SpongeNotePitch(9, "D_SHARP1")).put((Object)10, (Object)new SpongeNotePitch(10, "E1")).put((Object)11, (Object)new SpongeNotePitch(11, "F1")).put((Object)12, (Object)new SpongeNotePitch(12, "F_SHARP1")).put((Object)13, (Object)new SpongeNotePitch(13, "G1")).put((Object)14, (Object)new SpongeNotePitch(14, "G_SHARP1")).put((Object)15, (Object)new SpongeNotePitch(15, "A2")).put((Object)16, (Object)new SpongeNotePitch(16, "A_SHARP2")).put((Object)17, (Object)new SpongeNotePitch(17, "B2")).put((Object)18, (Object)new SpongeNotePitch(18, "C2")).put((Object)19, (Object)new SpongeNotePitch(19, "C_SHARP2")).put((Object)20, (Object)new SpongeNotePitch(20, "D2")).put((Object)21, (Object)new SpongeNotePitch(21, "D_SHARP2")).put((Object)22, (Object)new SpongeNotePitch(22, "E2")).put((Object)23, (Object)new SpongeNotePitch(23, "F2")).put((Object)24, (Object)new SpongeNotePitch(24, "F_SHARP2")).build();
    @RegisterCatalog(value=NotePitches.class)
    private final Map<String, NotePitch> notePitchMap = new HashMap<String, NotePitch>();

    public static NotePitch getPitch(byte note) {
        note = (byte)(note % 25);
        return pitchMappings.get(note);
    }

    @Override
    public Optional<NotePitch> getById(String id) {
        return Optional.ofNullable(this.notePitchMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<NotePitch> getAll() {
        return ImmutableList.copyOf(this.notePitchMap.values());
    }

    @Override
    public void registerDefaults() {
        for (SpongeNotePitch pitch : pitchMappings.values()) {
            this.notePitchMap.put(pitch.getId().toLowerCase(Locale.ENGLISH), pitch);
        }
    }
}

