/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.chat;

import java.util.Optional;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.SpongeTexts;

public final class ChatUtil {
    private ChatUtil() {
    }

    public static void sendMessage(ITextComponent component, MessageChannel channel, CommandSource source, boolean isChat) {
        Text raw = SpongeTexts.toText(component);
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter(raw);
        boolean isMainThread = Sponge.isServerAvailable() && Sponge.getServer().isMainThread();
        Cause cause = isMainThread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), source);
        MessageChannelEvent event = isChat ? SpongeEventFactory.createMessageChannelEventChat(cause, channel, Optional.of(channel), formatter, raw, false) : SpongeEventFactory.createMessageChannelEvent(cause, channel, Optional.of(channel), formatter, false);
        if (!SpongeImpl.postEvent(event) && !event.isMessageCancelled() && event.getChannel().isPresent()) {
            event.getChannel().get().send(source, event.getMessage(), isChat ? ChatTypes.CHAT : ChatTypes.SYSTEM);
        }
    }
}

