/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.common.world.biome.SpongeVirtualBiomeType;

public class SpongeVirtualBiomeTypeBuilder
implements VirtualBiomeType.Builder {
    private String name;
    private double temperature;
    private double humidity;
    private BiomeType persisted;
    private Function<World, BiomeGenerationSettings> func;

    public SpongeVirtualBiomeTypeBuilder() {
        this.reset();
    }

    @Override
    public VirtualBiomeType.Builder name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        return this;
    }

    @Override
    public VirtualBiomeType.Builder temperature(double temp) {
        this.temperature = temp;
        return this;
    }

    @Override
    public VirtualBiomeType.Builder humidity(double humidity) {
        this.humidity = humidity;
        return this;
    }

    @Override
    public VirtualBiomeType.Builder persistedType(BiomeType biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"biome");
        Preconditions.checkArgument((!(biome instanceof VirtualBiomeType) ? 1 : 0) != 0, (Object)"persisted type cannot be a virtual biome");
        this.persisted = biome;
        return this;
    }

    @Override
    public VirtualBiomeType.Builder from(VirtualBiomeType value) {
        this.name = value.getName();
        this.temperature = value.getTemperature();
        this.humidity = value.getHumidity();
        return this;
    }

    @Override
    public VirtualBiomeType.Builder settingsBuilder(Function<World, BiomeGenerationSettings> settingsBuilder) {
        this.func = (Function)Preconditions.checkNotNull(settingsBuilder, (Object)"settingsBuilder");
        return this;
    }

    @Override
    public VirtualBiomeType.Builder reset() {
        this.name = null;
        this.temperature = 0.0;
        this.humidity = 0.0;
        this.persisted = BiomeTypes.VOID;
        this.func = null;
        return this;
    }

    @Override
    public VirtualBiomeType build(String id) throws IllegalStateException {
        Preconditions.checkNotNull((Object)this.name, (Object)"name");
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)this.persisted, (Object)"persistedBiome");
        Preconditions.checkNotNull(this.func, (Object)"settings_function");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0);
        return new SpongeVirtualBiomeType(id, this.name, this.temperature, this.humidity, this.persisted, this.func);
    }
}

