/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenMelon;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.Melon;

public class MelonBuilder
implements Melon.Builder {
    private VariableAmount count;

    public MelonBuilder() {
        this.reset();
    }

    @Override
    public Melon.Builder perChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count, (Object)"count");
        return this;
    }

    @Override
    public Melon.Builder from(Melon value) {
        return this.perChunk(value.getMelonsPerChunk());
    }

    @Override
    public Melon.Builder reset() {
        this.count = VariableAmount.fixed(64.0);
        return this;
    }

    @Override
    public Melon build() throws IllegalStateException {
        Melon pop = (Melon)new WorldGenMelon();
        pop.setMelonsPerChunk(this.count);
        return pop;
    }
}

