/*
 * Decompiled with CFR 0.152.
 */
package bq_rf.client.gui.inventory;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiContainerCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiCanvas;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import bq_rf.block.TileRfStation;
import bq_rf.client.gui.inventory.ContainerRfStation;
import bq_rf.tasks.IRfTask;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.NonNullList;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class GuiRfStation
extends GuiContainerCanvas
implements IPEventListener,
INeedsRefresh {
    private final ContainerRfStation ssContainer;
    private final TileRfStation tile;
    private final NonNullList<DBEntry<IQuest>> quests = NonNullList.func_191196_a();
    private final NonNullList<DBEntry<ITask>> tasks = NonNullList.func_191196_a();
    private IGuiCanvas cvBackground;
    private IPanelButton btnSet;
    private IPanelButton btnRem;
    private IPanelButton btnQstLeft;
    private IPanelButton btnQstRight;
    private IPanelButton btnTskLeft;
    private IPanelButton btnTskRight;
    private PanelTextBox txtQstTitle;
    private PanelTextBox txtTskTitle;
    private IGuiPanel taskPanel;
    private int selQuest = 0;
    private int selTask = 0;

    public GuiRfStation(GuiScreen parent, InventoryPlayer invo, TileRfStation tile) {
        super(parent, (Container)new ContainerRfStation(invo, tile));
        this.ssContainer = (ContainerRfStation)this.field_147002_h;
        this.tile = tile;
    }

    public void refreshGui() {
        this.quests.clear();
        QuestCache qc = (QuestCache)this.field_146297_k.field_71439_g.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc != null) {
            this.quests.addAll((Collection)((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests()));
        }
        this.refreshTaskPanel();
    }

    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        this.quests.clear();
        this.taskPanel = null;
        QuestCache qc = (QuestCache)this.field_146297_k.field_71439_g.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc != null) {
            this.quests.addAll((Collection)((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests()));
        }
        this.cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)this.cvBackground);
        PanelTextBox txtTitle = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate((String)"betterquesting.title.submit_station", (Object[])new Object[0])).setAlignment(1);
        txtTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        this.cvBackground.addPanel((IGuiPanel)txtTitle);
        this.cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate((String)"gui.done", (Object[])new Object[0])));
        this.btnQstLeft = new PanelButton((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(0.5f, 0.0f, 0.5f, 0.0f), 8, 32, 16, 16, 0), -1, ""){

            public void onButtonClick() {
                GuiRfStation.this.selQuest--;
                GuiRfStation.this.refreshTaskPanel();
            }
        };
        ((PanelButton)this.btnQstLeft).setIcon(PresetIcon.ICON_LEFT.getTexture());
        this.cvBackground.addPanel((IGuiPanel)this.btnQstLeft);
        this.btnQstRight = new PanelButton((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(1.0f, 0.0f, 1.0f, 0.0f), -32, 32, 16, 16, 0), -1, ""){

            public void onButtonClick() {
                GuiRfStation.this.selQuest++;
                GuiRfStation.this.refreshTaskPanel();
            }
        };
        ((PanelButton)this.btnQstRight).setIcon(PresetIcon.ICON_RIGHT.getTexture());
        this.cvBackground.addPanel((IGuiPanel)this.btnQstRight);
        this.btnTskLeft = new PanelButton((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(0.5f, 0.0f, 0.5f, 0.0f), 8, 48, 16, 16, 0), -1, ""){

            public void onButtonClick() {
                GuiRfStation.this.selTask--;
                GuiRfStation.this.refreshTaskPanel();
            }
        };
        ((PanelButton)this.btnTskLeft).setIcon(PresetIcon.ICON_LEFT.getTexture());
        this.cvBackground.addPanel((IGuiPanel)this.btnTskLeft);
        this.btnTskRight = new PanelButton((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(1.0f, 0.0f, 1.0f, 0.0f), -32, 48, 16, 16, 0), -1, ""){

            public void onButtonClick() {
                GuiRfStation.this.selTask++;
                GuiRfStation.this.refreshTaskPanel();
            }
        };
        ((PanelButton)this.btnTskRight).setIcon(PresetIcon.ICON_RIGHT.getTexture());
        this.cvBackground.addPanel((IGuiPanel)this.btnTskRight);
        this.btnSet = new PanelButton((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(0.75f, 0.0f, 0.75f, 0.0f), -16, 64, 16, 16, 0), -1, ""){

            public void onButtonClick() {
                GuiRfStation.this.tile.setupTask(QuestingAPI.getQuestingUUID((EntityPlayer)GuiRfStation.this.field_146297_k.field_71439_g), (IQuest)((DBEntry)GuiRfStation.this.quests.get(GuiRfStation.this.selQuest)).getValue(), (ITask)((DBEntry)GuiRfStation.this.tasks.get(GuiRfStation.this.selTask)).getValue());
                GuiRfStation.this.tile.SyncTile(null);
                GuiRfStation.this.refreshTaskPanel();
            }
        };
        ((PanelButton)this.btnSet).setIcon(PresetIcon.ICON_TICK.getTexture(), (IGuiColor)new GuiColorStatic(-16711936), 0);
        this.cvBackground.addPanel((IGuiPanel)this.btnSet);
        this.btnRem = new PanelButton((IGuiRect)new GuiTransform((ReadableVector4f)new Vector4f(0.75f, 0.0f, 0.75f, 0.0f), 0, 64, 16, 16, 0), -1, ""){

            public void onButtonClick() {
                GuiRfStation.this.tile.reset();
                GuiRfStation.this.tile.SyncTile(null);
                GuiRfStation.this.refreshTaskPanel();
            }
        };
        ((PanelButton)this.btnRem).setIcon(PresetIcon.ICON_CROSS.getTexture(), (IGuiColor)new GuiColorStatic(-65536), 0);
        this.cvBackground.addPanel((IGuiPanel)this.btnRem);
        this.txtQstTitle = new PanelTextBox((IGuiRect)new GuiTransform(new Vector4f(0.5f, 0.0f, 1.0f, 0.0f), new GuiPadding(24, 36, 32, -48), 0), "");
        this.txtQstTitle.setColor(PresetColor.TEXT_MAIN.getColor()).setAlignment(1);
        this.cvBackground.addPanel((IGuiPanel)this.txtQstTitle);
        this.txtTskTitle = new PanelTextBox((IGuiRect)new GuiTransform(new Vector4f(0.5f, 0.0f, 1.0f, 0.0f), new GuiPadding(24, 52, 32, -64), 0), "");
        this.txtTskTitle.setColor(PresetColor.TEXT_MAIN.getColor()).setAlignment(1);
        this.cvBackground.addPanel((IGuiPanel)this.txtTskTitle);
        this.setInventoryPosition((this.field_146999_f - 32) / 4 + 16 - 81, (this.field_147000_g - 32) / 2 + 16 - 49);
        this.refreshTaskPanel();
    }

    private void setInventoryPosition(int x, int y) {
        this.ssContainer.moveInventorySlots(x + 1, y + 23);
        this.ssContainer.moveSubmitSlot(x + 55, y + 1);
        this.ssContainer.moveReturnSlot(x + 91, y + 1);
        for (int i = 0; i < 36; ++i) {
            int j = i % 9 * 18;
            int k = i / 9 * 18;
            if (i >= 27) {
                k += 4;
            }
            this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, x + j, y + k + 22, 18, 18, -1), PresetTexture.ITEM_FRAME.getTexture()));
        }
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, x + 54, y, 18, 18, -1), PresetTexture.ITEM_FRAME.getTexture()));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, x + 72, y, 18, 18, -1), PresetIcon.ICON_RIGHT.getTexture()));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, x + 90, y, 18, 18, -1), PresetTexture.ITEM_FRAME.getTexture()));
    }

    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    private void refreshTaskPanel() {
        if (this.taskPanel != null) {
            this.cvBackground.removePanel(this.taskPanel);
        }
        if (this.tile.isSetup()) {
            DBEntry qdbe = null;
            for (int i = 0; i < this.quests.size(); ++i) {
                DBEntry entry = (DBEntry)this.quests.get(i);
                if (entry.getID() != this.tile.questID) continue;
                this.selQuest = i;
                qdbe = entry;
                break;
            }
            if (qdbe != null) {
                List tmpTasks = ((IQuest)qdbe.getValue()).getTasks().getEntries();
                for (int i = 0; i < tmpTasks.size(); ++i) {
                    if (((DBEntry)tmpTasks.get(i)).getID() != this.tile.taskID) continue;
                    this.selQuest = i;
                    break;
                }
            }
            this.btnRem.setActive(true);
            this.btnSet.setActive(false);
            this.btnQstLeft.setActive(false);
            this.btnQstRight.setActive(false);
            this.btnTskLeft.setActive(false);
            this.btnTskRight.setActive(false);
        } else {
            this.btnRem.setActive(false);
            this.btnSet.setActive(false);
            this.btnQstLeft.setActive(true);
            this.btnQstRight.setActive(true);
            this.btnTskLeft.setActive(true);
            this.btnTskRight.setActive(true);
        }
        if (this.quests.size() <= 0) {
            this.selQuest = -1;
            this.selTask = -1;
            this.txtQstTitle.setText("");
            this.txtTskTitle.setText("");
            return;
        }
        this.selQuest = this.lazyPosMod(this.selQuest, this.quests.size());
        DBEntry entry = (DBEntry)this.quests.get(this.selQuest);
        this.txtQstTitle.setText(QuestTranslation.translate((String)((String)((IQuest)entry.getValue()).getProperty(NativeProps.NAME)), (Object[])new Object[0]));
        this.tasks.clear();
        this.tasks.addAll((Collection)((IQuest)entry.getValue()).getTasks().getEntries());
        if (this.tasks.size() <= 0) {
            this.selTask = -1;
            this.txtTskTitle.setText("");
            return;
        }
        this.selTask = this.lazyPosMod(this.selTask, this.tasks.size());
        DBEntry curTask = (DBEntry)this.tasks.get(this.selTask);
        this.txtTskTitle.setText(QuestTranslation.translate((String)((ITask)curTask.getValue()).getUnlocalisedName(), (Object[])new Object[0]));
        this.btnSet.setActive(!this.tile.isSetup() && curTask.getValue() instanceof IRfTask);
        this.taskPanel = ((ITask)curTask.getValue()).getTaskGui((IGuiRect)new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 88, 16, 24), 0), entry);
        if (this.taskPanel != null) {
            this.cvBackground.addPanel(this.taskPanel);
        }
    }

    private int lazyPosMod(int a, int b) {
        if (b <= 0) {
            return a;
        }
        while (a < 0) {
            a += b;
        }
        return a % b;
    }
}

