/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.tile.IAcceleratorComponent;
import lach_01298.qmd.accelerator.tile.TileAcceleratorRFCavity;
import lach_01298.qmd.util.Util;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class RFCavity {
    private final Accelerator accelerator;
    private BlockPos pos;
    private EnumFacing.Axis axis;
    private String type;
    private final Long2ObjectMap<IAcceleratorComponent> components = new Long2ObjectOpenHashMap();

    public RFCavity(Accelerator accelerator, BlockPos pos, EnumFacing.Axis axis) {
        this.accelerator = accelerator;
        this.pos = pos;
        this.axis = axis;
        this.setType();
        this.addComponents();
    }

    private void setType() {
        if (this.accelerator.WORLD.func_175625_s(this.pos.func_177984_a()) instanceof TileAcceleratorRFCavity) {
            TileAcceleratorRFCavity cavity = (TileAcceleratorRFCavity)this.accelerator.WORLD.func_175625_s(this.pos.func_177984_a());
            this.type = cavity.name.toUpperCase();
        } else {
            Util.getLogger().error("could not set RF Cavity type becuase" + this.accelerator.WORLD.func_175625_s(this.pos.func_177984_a()) + " at " + this.pos.func_177984_a() + " is not a instance of TileAcceleratorRFCavity");
        }
    }

    private void addComponents() {
        this.addComponent(this.pos);
        this.addComponent(this.pos.func_177984_a());
        this.addComponent(this.pos.func_177977_b());
        if (this.axis == EnumFacing.Axis.X) {
            this.addComponent(this.pos.func_177978_c());
            this.addComponent(this.pos.func_177968_d());
            this.addComponent(this.pos.func_177978_c().func_177984_a());
            this.addComponent(this.pos.func_177978_c().func_177977_b());
            this.addComponent(this.pos.func_177968_d().func_177984_a());
            this.addComponent(this.pos.func_177968_d().func_177977_b());
        }
        if (this.axis == EnumFacing.Axis.Z) {
            this.addComponent(this.pos.func_177974_f());
            this.addComponent(this.pos.func_177976_e());
            this.addComponent(this.pos.func_177974_f().func_177984_a());
            this.addComponent(this.pos.func_177974_f().func_177977_b());
            this.addComponent(this.pos.func_177976_e().func_177984_a());
            this.addComponent(this.pos.func_177976_e().func_177977_b());
        }
    }

    private void addComponent(BlockPos postion) {
        if (this.accelerator.WORLD.func_175625_s(postion) instanceof IAcceleratorComponent) {
            this.components.put(postion.func_177986_g(), (Object)((IAcceleratorComponent)this.accelerator.WORLD.func_175625_s(postion)));
        } else {
            Util.getLogger().error("could not add tile to RF Cavity becuase" + this.accelerator.WORLD.func_175625_s(postion) + " at " + postion + " is not a instance of IAcceleratorComponent");
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public EnumFacing.Axis getAxis() {
        return this.axis;
    }

    public String getType() {
        return this.type;
    }

    public Long2ObjectMap<IAcceleratorComponent> getComponents() {
        return this.components;
    }
}

