/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.entity;

import lach_01298.qmd.network.BeamProjectileUpdatePacket;
import lach_01298.qmd.network.QMDPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class EntityBeamProjectile
extends Entity {
    protected double length = 1.0;
    protected int livingTime;
    protected EntityPlayer owner;
    protected EnumHand hand;

    public EntityBeamProjectile(World world) {
        super(world);
        this.livingTime = 100;
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityBeamProjectile(World world, EntityPlayer player, double length, EnumHand hand, int lifetime) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.eyeHeight, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.owner = player;
        this.hand = hand;
        this.length = length;
        this.livingTime = lifetime;
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.field_70165_t - this.length, this.field_70163_u - this.length, this.field_70161_v - this.length, this.field_70165_t + this.length, this.field_70163_u * 2.0 + this.length, this.field_70161_v + this.length);
    }

    public void setOwner(EntityPlayer owner) {
        this.owner = owner;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setHand(EnumHand hand) {
        this.hand = hand;
    }

    public EntityPlayer getOwner() {
        return this.owner;
    }

    public double getLength() {
        return this.length;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.livingTime = compound.func_74762_e("livingTime");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("livingTime", this.livingTime);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.livingTime <= 0) {
            this.func_70106_y();
        } else {
            --this.livingTime;
        }
        this.sendUpdatePacket();
    }

    protected void sendUpdatePacket() {
        if (!this.field_70170_p.field_72995_K) {
            QMDPacketHandler.instance.sendToAllAround((IMessage)new BeamProjectileUpdatePacket(this), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
        }
    }
}

