/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particle;

import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particle.IParticleStorage;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particle.ParticleStorageInfo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ParticleStorage
implements IParticleStorage,
IParticleStackHandler {
    protected ParticleStack particleStack;
    protected TileEntity tile;
    protected long maxEnergy;
    protected long minEnergy;
    protected int capacity;

    public ParticleStorage(ParticleStack stack, long maxEnergy, int capacity, long minEnergy) {
        this.particleStack = stack;
        this.maxEnergy = maxEnergy;
        this.capacity = capacity;
        this.minEnergy = minEnergy;
    }

    public ParticleStorage(ParticleStack stack, long maxEnergy, int capacity) {
        this.particleStack = stack;
        this.maxEnergy = maxEnergy;
        this.capacity = capacity;
        this.minEnergy = 0L;
    }

    public ParticleStorage(ParticleStack stack, long maxEnergy) {
        this.particleStack = stack;
        this.maxEnergy = maxEnergy;
        this.capacity = Integer.MAX_VALUE;
        this.minEnergy = 0L;
    }

    public ParticleStorage() {
        this.particleStack = null;
        this.maxEnergy = Long.MAX_VALUE;
        this.capacity = Integer.MAX_VALUE;
        this.minEnergy = 0L;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.particleStack = nbt.func_74764_b("particle_stack") ? ParticleStack.loadParticleStackFromNBT(nbt.func_74775_l("particle_stack")) : null;
        this.maxEnergy = nbt.func_74763_f("maxEnergy");
        this.capacity = nbt.func_74762_e("capacity");
        this.minEnergy = nbt.func_74763_f("minEnergy");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.particleStack != null) {
            this.particleStack.writeToNBT(tag);
        } else {
            new ParticleStack().writeToNBT(tag);
        }
        nbt.func_74782_a("particle_stack", (NBTBase)tag);
        nbt.func_74772_a("maxEnergy", this.maxEnergy);
        nbt.func_74768_a("capacity", this.capacity);
        nbt.func_74772_a("minEnergy", this.minEnergy);
        return nbt;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt, int id) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        nbt.func_74782_a("ParticleStorage" + id, (NBTBase)tag);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt, int id) {
        if (nbt.func_74764_b("ParticleStorage" + id)) {
            NBTTagCompound tag = nbt.func_74775_l("ParticleStorage" + id);
            this.readFromNBT(tag);
        }
    }

    public void setParticleStack(ParticleStack stack) {
        this.particleStack = stack;
    }

    public void setTileEntity(TileEntity tile) {
        this.tile = tile;
    }

    @Override
    public ParticleStorageInfo getInfo() {
        return new ParticleStorageInfo(this);
    }

    @Override
    public boolean reciveParticle(EnumFacing side, ParticleStack stack) {
        if (stack != null) {
            if (this.particleStack == null) {
                this.particleStack = stack.copy();
                return true;
            }
            if (this.particleStack.getParticle() == stack.getParticle() && stack.getMeanEnergy() >= this.minEnergy && stack.getMeanEnergy() <= this.maxEnergy && this.particleStack.getAmount() + stack.getAmount() <= this.capacity) {
                this.particleStack.setMeanEnergy((stack.getMeanEnergy() * (long)stack.getAmount() + this.particleStack.getMeanEnergy() * (long)this.particleStack.getAmount()) / (long)(stack.getAmount() + this.particleStack.getAmount()));
                this.particleStack.addAmount(stack.getAmount());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canReciveParticle(EnumFacing side, ParticleStack stack) {
        if (stack != null) {
            if (this.particleStack == null) {
                return true;
            }
            if (this.particleStack.getParticle() == stack.getParticle() && stack.getMeanEnergy() > this.minEnergy && stack.getMeanEnergy() < this.maxEnergy && this.particleStack.getAmount() + stack.getAmount() <= this.capacity) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractParticle(EnumFacing side) {
        return this.particleStack != null;
    }

    @Override
    public ParticleStack getParticleStack() {
        return this.particleStack;
    }

    @Override
    public long getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public long getMinEnergy() {
        return this.minEnergy;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxEnergy(long maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    public void setMinEnergy(long minEnergy) {
        this.minEnergy = minEnergy;
    }

    @Override
    public ParticleStack extractParticle(EnumFacing side) {
        if (this.canExtractParticle(side)) {
            ParticleStack stack = this.particleStack;
            this.particleStack = null;
            return stack;
        }
        return null;
    }

    @Override
    public ParticleStack extractParticle(EnumFacing side, Particle type) {
        if (this.canExtractParticle(side) && this.particleStack.getParticle() == type) {
            return this.extractParticle(side);
        }
        return null;
    }

    @Override
    public ParticleStack extractParticle(EnumFacing side, int amount) {
        if (this.canExtractParticle(side)) {
            ParticleStack stack = this.particleStack.copy();
            if (this.particleStack.getAmount() > amount) {
                stack.setAmount(amount);
            } else {
                stack.setAmount(this.particleStack.getAmount());
            }
            this.particleStack.removeAmount(amount);
        }
        return null;
    }

    @Override
    public ParticleStack extractParticle(EnumFacing side, Particle type, int Amount) {
        if (this.canExtractParticle(side) && this.particleStack.getParticle() == type) {
            return this.extractParticle(side, Amount);
        }
        return null;
    }

    @Override
    public ParticleStack getParticle() {
        if (this.particleStack != null) {
            return this.particleStack.copy();
        }
        return null;
    }
}

