/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particleChamber;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.network.BeamDumpUpdatePacket;
import lach_01298.qmd.multiblock.network.ParticleChamberUpdatePacket;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particleChamber.ParticleChamber;
import lach_01298.qmd.particleChamber.ParticleChamberLogic;
import lach_01298.qmd.particleChamber.tile.TileParticleChamber;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberBeam;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberBeamPort;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberEnergyPort;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberFluidPort;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeInfo;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.block.property.BlockProperties;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.internal.fluid.Tank;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class BeamDumpLogic
extends ParticleChamberLogic {
    public QMDRecipeInfo<QMDRecipe> recipeInfo;
    public QMDRecipeInfo<QMDRecipe> rememberedRecipeInfo;
    protected TileParticleChamber mainChamber;
    public long particleWorkDone = 0L;
    public long recipeParticleWork = 100L;

    public BeamDumpLogic(ParticleChamberLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "beam_dump";
    }

    @Override
    public int getMaximumInteriorLength() {
        return 1;
    }

    @Override
    public boolean isMachineWhole() {
        if (this.getMultiblock().getExteriorLengthX() != this.getMultiblock().getExteriorLengthZ()) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_square", null, new Object[0]);
            return false;
        }
        if (this.getMultiblock().getExteriorLengthX() % 2 != 1) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_odd", null, new Object[0]);
            return false;
        }
        BlockPos middle = this.getMultiblock().getExtremeCoord(false, false, false).func_177982_a(this.getMultiblock().getExteriorLengthX() / 2, this.getMultiblock().getExteriorLengthY() / 2, this.getMultiblock().getExteriorLengthZ() / 2);
        if (!(this.getMultiblock().WORLD.func_175625_s(middle) instanceof TileParticleChamber)) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_have_target", middle, new Object[0]);
            return false;
        }
        TileParticleChamber target = (TileParticleChamber)this.getMultiblock().WORLD.func_175625_s(middle);
        int ports = 0;
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if (!(this.getMultiblock().WORLD.func_175625_s(middle.func_177967_a(face, this.getMultiblock().getExteriorLengthX() / 2)) instanceof TileParticleChamberBeamPort)) continue;
            ++ports;
            for (int i = 1; i <= this.getMultiblock().getExteriorLengthX() / 2 - 1; ++i) {
                if (this.getMultiblock().WORLD.func_175625_s(middle.func_177967_a(face, i)) instanceof TileParticleChamberBeam) continue;
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_beam", middle.func_177967_a(face, i), new Object[0]);
                return false;
            }
        }
        if (ports != this.getPartMap(TileParticleChamberBeamPort.class).size()) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.beam_port_wrong_spot", null, new Object[0]);
            return false;
        }
        int inputs = 0;
        for (TileParticleChamberBeamPort tile : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
            if (tile.getIOType() != EnumTypes.IOType.INPUT) continue;
            ++inputs;
        }
        if (inputs != 1) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_have_input_beam", null, new Object[0]);
            return false;
        }
        if (inputs != ports) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.beam_dump.only_input_beam", null, new Object[0]);
            return false;
        }
        boolean outlet = false;
        for (TileParticleChamberFluidPort port : this.getPartMap(TileParticleChamberFluidPort.class).values()) {
            if (!((Boolean)port.getBlockState(port.func_174877_v()).func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) continue;
            outlet = true;
        }
        if (!outlet) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.beam_dump.must_have_fluid_output", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(TileParticleChamberEnergyPort.class).size() < 1) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.need_energy_ports", null, new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public int getMinimumInteriorLength() {
        return 1;
    }

    @Override
    public void onChamberFormed() {
        this.onResetStats();
        this.getMultiblock().tanks.get(1).setCapacity(QMDConfig.particle_chamber_output_tank_capacity * this.getCapacityMultiplier());
        if (!this.getWorld().field_72995_K) {
            ObjectIterator objectIterator = this.getPartMap(TileParticleChamber.class).values().iterator();
            while (objectIterator.hasNext()) {
                TileParticleChamber target;
                this.mainChamber = target = (TileParticleChamber)objectIterator.next();
            }
            Object input = null;
            for (TileParticleChamberBeamPort tile : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
                tile.setIONumber(0);
            }
        }
        super.onChamberFormed();
    }

    @Override
    public void onMachineDisassembled() {
        this.mainChamber = null;
        for (TileParticleChamberBeamPort tile : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
            tile.setIONumber(0);
        }
        super.onMachineDisassembled();
    }

    @Override
    public boolean onUpdateServer() {
        this.getMultiblock().beams.get(0).setParticleStack(null);
        this.pull();
        if (this.isChamberOn() && this.getMultiblock().energyStorage.extractEnergy(this.getMultiblock().requiredEnergy, true) == this.getMultiblock().requiredEnergy) {
            this.refreshRecipe();
            if (this.recipeInfo != null) {
                if (this.rememberedRecipeInfo != null && this.rememberedRecipeInfo.getRecipe() != this.recipeInfo.getRecipe()) {
                    this.particleWorkDone = 0L;
                }
                this.rememberedRecipeInfo = this.recipeInfo;
                if (this.canProduceProduct()) {
                    this.getMultiblock().energyStorage.changeEnergyStored((long)(-this.getMultiblock().requiredEnergy));
                    this.particleWorkDone = (long)((double)this.particleWorkDone + (double)this.getMultiblock().beams.get(0).getParticleStack().getAmount() * this.getMultiblock().efficiency);
                    this.produceProduct();
                }
            }
        }
        return super.onUpdateServer();
    }

    private boolean canProduceProduct() {
        FluidStack product = (FluidStack)this.recipeInfo.getRecipe().getFluidProducts().get(0).getStack();
        return this.getMultiblock().tanks.get(1).fill(product, false) == product.amount && this.getMultiblock().tanks.get(1).getCapacity() >= this.getMultiblock().tanks.get(1).getFluidAmount() + product.amount;
    }

    private void produceProduct() {
        this.recipeParticleWork = ((ParticleStack)this.recipeInfo.getRecipe().getParticleIngredients().get(0).getStack()).getAmount();
        this.particleWorkDone = Math.min(this.particleWorkDone, this.recipeParticleWork * 1000L);
        while (this.particleWorkDone >= this.recipeParticleWork && this.canProduceProduct()) {
            FluidStack product = (FluidStack)this.recipeInfo.getRecipe().getFluidProducts().get(0).getStack();
            this.getMultiblock().tanks.get(1).fill(product, true);
            this.particleWorkDone = Math.max(0L, this.particleWorkDone - this.recipeParticleWork);
        }
    }

    public void onResetStats() {
        this.getMultiblock().efficiency = 1.0;
        this.getMultiblock().requiredEnergy = QMDConfig.beam_dump_power;
    }

    protected void refreshRecipe() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<ParticleStack> particles = new ArrayList<ParticleStack>();
        particles.add(this.getMultiblock().beams.get(0).getParticleStack());
        this.recipeInfo = QMDRecipes.beam_dump.getRecipeInfoFromInputs(items, new ArrayList<Tank>(), particles);
    }

    @Override
    public ParticleChamberUpdatePacket getMultiblockUpdatePacket() {
        return new BeamDumpUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isChamberOn, this.getMultiblock().requiredEnergy, this.getMultiblock().efficiency, this.getMultiblock().energyStorage, this.particleWorkDone, this.recipeParticleWork, this.getMultiblock().tanks, this.getMultiblock().beams);
    }

    @Override
    public void onMultiblockUpdatePacket(ParticleChamberUpdatePacket message) {
        super.onMultiblockUpdatePacket(message);
        if (message instanceof BeamDumpUpdatePacket) {
            BeamDumpUpdatePacket packet = (BeamDumpUpdatePacket)message;
            this.getMultiblock().beams = packet.beams;
            for (int i = 0; i < this.getMultiblock().tanks.size(); ++i) {
                this.getMultiblock().tanks.get(i).readInfo(message.tanksInfo.get(i));
            }
            this.particleWorkDone = packet.particleWorkDone;
            this.recipeParticleWork = packet.recipeParticleWork;
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
        logicTag.func_74772_a("particleCount", this.particleWorkDone);
        logicTag.func_74772_a("recipeParticleCount", this.recipeParticleWork);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
        this.particleWorkDone = logicTag.func_74763_f("particleCount");
        this.recipeParticleWork = logicTag.func_74763_f("recipeParticleCount");
    }
}

