/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.api.reg.obj;

import icbm.classic.ICBMClassic;
import icbm.classic.api.missiles.parts.IBuildableObject;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public interface IBuilderRegistry<Part extends IBuildableObject> {
    public void register(ResourceLocation var1, Supplier<Part> var2);

    public Part build(ResourceLocation var1);

    default public NBTTagList save(Collection<Part> parts) {
        NBTTagList list = new NBTTagList();
        for (IBuildableObject part : parts) {
            NBTTagCompound save = this.save(part);
            if (save == null) continue;
            list.func_74742_a((NBTBase)save);
        }
        return list;
    }

    default public NBTTagCompound save(Part part) {
        if (part == null) {
            ICBMClassic.logger().warn("Failed to save part due to null value", (Throwable)new RuntimeException());
            return null;
        }
        if (part.getRegistryName() == null) {
            ICBMClassic.logger().warn("Failed to save part due to missing registry name: " + part, (Throwable)new RuntimeException());
            return null;
        }
        NBTTagCompound save = new NBTTagCompound();
        save.func_74778_a("id", part.getRegistryName().toString());
        NBTTagCompound additionalData = (NBTTagCompound)part.serializeNBT();
        if (additionalData != null && !additionalData.func_82582_d()) {
            save.func_74782_a("data", (NBTBase)additionalData);
        }
        return save;
    }

    default public <C extends Collection<Part>> C load(NBTTagList save, C list) {
        for (int i = 0; i < save.func_74745_c(); ++i) {
            Part part = this.load((NBTTagCompound)save.func_179238_g(i));
            if (part == null) continue;
            list.add(part);
        }
        return list;
    }

    default public Part load(NBTTagCompound save) {
        if (save != null && !save.func_82582_d() && save.func_74764_b("id")) {
            ResourceLocation id = new ResourceLocation(save.func_74779_i("id"));
            Part part = this.build(id);
            if (part != null && save.func_74764_b("data")) {
                NBTTagCompound additionalData = save.func_74775_l("data");
                part.deserializeNBT((NBTBase)additionalData);
            }
            return part;
        }
        return null;
    }
}

