/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.imp;

import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.explosion.responses.BlastNullResponses;
import icbm.classic.api.explosion.responses.BlastResponse;
import javax.annotation.Nonnull;
import net.minecraft.world.World;

public abstract class BlastBase
implements IBlastInit {
    private World world;
    private double x;
    private double y;
    private double z;
    private boolean locked;
    private double blastSize;

    @Override
    public float getBlastRadius() {
        return (float)this.blastSize;
    }

    @Override
    public IBlastInit setBlastSize(double size) {
        this.blastSize = size;
        return this;
    }

    @Override
    public void clearBlast() {
    }

    @Override
    @Nonnull
    public BlastResponse runBlast() {
        World world = this.world();
        if (world != null) {
            if (!world.field_72995_K) {
                return this.triggerBlast();
            }
            return BlastState.TRIGGERED.genericResponse;
        }
        return BlastNullResponses.WORLD.get();
    }

    protected abstract BlastResponse triggerBlast();

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public IBlastInit setBlastWorld(World world) {
        if (!this.locked) {
            this.world = world;
        }
        return this;
    }

    @Override
    public IBlastInit setBlastPosition(double x, double y, double z) {
        if (!this.locked) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
        return this;
    }

    @Override
    public IBlastInit buildBlast() {
        this.locked = true;
        return this;
    }
}

