/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.targeting;

import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.api.missiles.parts.IMissileTargetDelayed;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class BasicTargetData
implements IMissileTarget,
IMissileTargetDelayed {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "basic");
    private Vec3d position;
    private int firingDelay = 0;

    public BasicTargetData() {
    }

    public BasicTargetData(double x, double y, double z) {
        this.position = new Vec3d(x, y, z);
    }

    public BasicTargetData(Vec3d position) {
        this.position = position;
    }

    public BasicTargetData(BlockPos pos) {
        this.position = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    @Override
    public Vec3d getPosition() {
        return this.position;
    }

    public BasicTargetData withFiringDelay(int ticks) {
        this.firingDelay = ticks;
        return this;
    }

    @Override
    public int getFiringDelay() {
        return this.firingDelay;
    }

    @Override
    public IMissileTarget cloneWithoutDelay() {
        return new BasicTargetData(this.position);
    }

    @Override
    public boolean isValid() {
        return this.position != null && Double.isNaN(this.getX()) && Double.isFinite(this.getX()) && Double.isNaN(this.getY()) && Double.isFinite(this.getY()) && Double.isNaN(this.getZ()) && Double.isFinite(this.getZ());
    }

    @Override
    public double getX() {
        return this.position != null ? this.position.field_72450_a : Double.NaN;
    }

    @Override
    public double getY() {
        return this.position != null ? this.position.field_72448_b : Double.NaN;
    }

    @Override
    public double getZ() {
        return this.position != null ? this.position.field_72449_c : Double.NaN;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return REG_NAME;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound saveData = new NBTTagCompound();
        saveData.func_74780_a("x", this.position.field_72450_a);
        saveData.func_74780_a("y", this.position.field_72448_b);
        saveData.func_74780_a("z", this.position.field_72449_c);
        saveData.func_74768_a("firingDelay", this.firingDelay);
        return saveData;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        double x = nbt.func_74769_h("x");
        double y = nbt.func_74769_h("y");
        double z = nbt.func_74769_h("z");
        this.position = new Vec3d(x, y, z);
        this.firingDelay = nbt.func_74762_e("firingDelay");
    }

    public boolean equals(Object other) {
        if (other instanceof BasicTargetData) {
            return Objects.equals(((BasicTargetData)other).position, this.position);
        }
        return false;
    }
}

