/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.energy.storage;

import icbm.classic.config.ConfigMain;
import icbm.classic.lib.energy.storage.EnergyActionType;
import icbm.classic.lib.energy.storage.EnergyChangeCallback;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.energy.system.IEnergySystem;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyBuffer
implements IEnergyStorage,
INBTSerializable<NBTTagInt> {
    private final Supplier<Integer> storageLimit;
    private EnergyChangeCallback onEnergyChanged;
    private Supplier<Boolean> canExtract;
    private Supplier<Boolean> canReceive;
    private Supplier<Integer> receiveLimit;
    private Supplier<Integer> extractLimit;
    private int energyStorage;

    public EnergyBuffer(Supplier<Integer> storageLimit) {
        this.storageLimit = storageLimit;
    }

    public EnergyBuffer withOnChange(EnergyChangeCallback onEnergyChanged) {
        this.onEnergyChanged = onEnergyChanged;
        return this;
    }

    public EnergyBuffer withCanExtract(Supplier<Boolean> canExtract) {
        this.canExtract = canExtract;
        return this;
    }

    public EnergyBuffer withCanReceive(Supplier<Boolean> canReceive) {
        this.canReceive = canReceive;
        return this;
    }

    public EnergyBuffer withExtractLimit(Supplier<Integer> extractLimit) {
        this.extractLimit = extractLimit;
        return this;
    }

    public EnergyBuffer withReceiveLimit(Supplier<Integer> receiveLimit) {
        this.receiveLimit = receiveLimit;
        return this;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int inputEnergy = Math.min(maxReceive, Optional.ofNullable(this.receiveLimit).map(Supplier::get).orElse(Integer.MAX_VALUE));
        return this.receiveEnergyInternal(inputEnergy, simulate);
    }

    public int receiveEnergyInternal(int inputEnergy, boolean simulate) {
        int maxEnergy = this.getMaxEnergyStored();
        int energyStored = this.getEnergyStored();
        int roomLeft = maxEnergy - energyStored;
        if (inputEnergy <= 0 || roomLeft <= 0) {
            return 0;
        }
        int toAdd = Math.min(roomLeft, inputEnergy);
        if (!simulate) {
            this.setEnergyInternal(energyStored + toAdd, EnergyActionType.ADD);
        }
        return toAdd;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int desiredEnergy = Math.min(maxExtract, Optional.ofNullable(this.extractLimit).map(Supplier::get).orElse(Integer.MAX_VALUE));
        return this.extractEnergyInternal(desiredEnergy, simulate);
    }

    public int extractEnergyInternal(int desiredEnergy, boolean simulate) {
        int maxEnergy = this.getMaxEnergyStored();
        int energyStored = this.getEnergyStored();
        if (desiredEnergy <= 0 || energyStored <= 0) {
            return 0;
        }
        int toRemove = Math.min(maxEnergy, desiredEnergy);
        if (!simulate) {
            this.setEnergyInternal(energyStored - desiredEnergy, EnergyActionType.REMOVE);
        }
        return toRemove;
    }

    public boolean consumePower(int amount, boolean simulate) {
        return !ConfigMain.REQUIRES_POWER || this.extractEnergyInternal(amount, simulate) >= amount;
    }

    public ItemStack dischargeItem(ItemStack itemStack) {
        int removed;
        int energyLeftToStore;
        IEnergySystem system = EnergySystem.getSystem(itemStack, null);
        if (system != null && this.canReceive() && (energyLeftToStore = this.getMaxEnergyStored() - this.getEnergyStored()) > 0 && (removed = system.removeEnergy(itemStack, null, energyLeftToStore, false)) > 0) {
            this.receiveEnergy(removed, false);
        }
        return itemStack;
    }

    public int getEnergyStored() {
        return this.energyStorage;
    }

    public int getMaxEnergyStored() {
        return this.storageLimit.get();
    }

    public boolean canExtract() {
        return Optional.ofNullable(this.canExtract).map(Supplier::get).orElse(false);
    }

    public boolean canReceive() {
        return Optional.ofNullable(this.canReceive).map(Supplier::get).orElse(true);
    }

    public void setEnergyStored(int energy) {
        this.setEnergyInternal(energy, EnergyActionType.SET);
    }

    private void setEnergyInternal(int energy, EnergyActionType type) {
        int prev = this.energyStorage;
        if (energy != prev) {
            this.energyStorage = Math.min(this.getMaxEnergyStored(), Math.max(0, energy));
            Optional.ofNullable(this.onEnergyChanged).ifPresent(f -> f.onChange(prev, energy, type));
        }
    }

    public NBTTagInt serializeNBT() {
        return new NBTTagInt(this.getEnergyStored());
    }

    public void deserializeNBT(NBTTagInt nbt) {
        this.setEnergyStored(nbt.func_150287_d());
    }
}

