/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.lwjgl.input.Mouse;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.detail.ModAuxiliaries;
import wile.engineersdecor.detail.Networking;

public class BlockDecorCraftingTable
extends BlockDecorDirected {
    public static boolean with_assist = true;
    public static boolean with_assist_direct_history_refab = false;
    public static boolean with_assist_quickmove_buttons = false;
    public static boolean with_crafting_slot_mouse_scrolling = true;

    public static final void on_config(boolean without_crafting_assist, boolean with_assist_immediate_history_refab, boolean with_quickmove_buttons, boolean without_crafting_slot_mouse_scrolling) {
        with_assist = !without_crafting_assist;
        with_assist_direct_history_refab = with_assist_immediate_history_refab;
        with_assist_quickmove_buttons = with_quickmove_buttons;
        with_crafting_slot_mouse_scrolling = !without_crafting_slot_mouse_scrolling;
        CraftingHistory.max_history_size(32);
    }

    public BlockDecorCraftingTable(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
        this.func_149713_g(0);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)ModEngineersDecor.instance, 213101, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
            return;
        }
        NBTTagCompound inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
        if (inventory_nbt.func_82582_d()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).readnbt(inventory_nbt);
        ((BTileEntity)te).func_70296_d();
    }

    private ItemStack itemize_with_inventory(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((Block)this, 1);
        NBTTagCompound inventory_nbt = new NBTTagCompound();
        ItemStackHelper.func_191281_a((NBTTagCompound)inventory_nbt, ((BTileEntity)te).stacks, (boolean)false);
        if (!inventory_nbt.func_82582_d()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inventory", (NBTBase)inventory_nbt);
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = this.itemize_with_inventory(world, pos);
        if (stack != ItemStack.field_190927_a) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
            world.func_175698_g(pos);
            world.func_175713_t(pos);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        for (ItemStack stack : ((BTileEntity)te).stacks) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((BTileEntity)te).reset();
        super.onBlockExploded(world, pos, explosion);
    }

    public static Object getServerGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BContainer(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static Object getClientGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BGui(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static class BTileEntity
    extends TileEntity
    implements IInventory,
    Networking.IPacketReceiver {
        public static final int CRAFTING_SLOTS_BEGIN = 0;
        public static final int NUM_OF_CRAFTING_SLOTS = 9;
        public static final int STORAGE_SLOTS_BEGIN = 9;
        public static final int NUM_OF_STORAGE_SLOTS = 8;
        public static final int NUM_OF_SLOTS = 17;
        protected NonNullList<ItemStack> stacks;
        protected final CraftingHistory history = new CraftingHistory();
        protected boolean has_recipe_collision_ = false;

        public BTileEntity() {
            this.stacks = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
        }

        public void reset() {
            this.stacks = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
        }

        public void readnbt(NBTTagCompound compound) {
            this.reset();
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.stacks);
            while (this.stacks.size() < 17) {
                this.stacks.add((Object)ItemStack.field_190927_a);
            }
            this.history.read(compound);
        }

        private void writenbt(NBTTagCompound compound) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks);
            this.history.write(compound);
        }

        private boolean has_recipe_collision() {
            return this.has_recipe_collision_;
        }

        private boolean itemstack_recipe_match(ItemStack grid_stack, ItemStack history_stack) {
            if (this.history.current_recipe() != null) {
                for (Ingredient ingredient : this.history.current_recipe().func_192400_c()) {
                    boolean grid_match = false;
                    boolean dist_match = false;
                    for (ItemStack match : ingredient.func_193365_a()) {
                        if (match.func_185136_b(grid_stack)) {
                            dist_match = true;
                        }
                        if (match.func_185136_b(history_stack)) {
                            grid_match = true;
                        }
                        if (!dist_match || !grid_match) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private List<ItemStack> refab_crafting_stacks() {
            int i;
            ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
            List<ItemStack> tocraft = this.history.current();
            int[] stack_sizes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
            if (tocraft.isEmpty()) {
                return slots;
            }
            for (int i2 = 0; i2 < 9 && i2 + 1 < tocraft.size(); ++i2) {
                ItemStack needed = tocraft.get(i2 + 1);
                ItemStack palced = this.func_70301_a(i2 + 0);
                if (needed.func_190926_b() && !palced.func_190926_b()) {
                    return slots;
                }
                if (!palced.func_190926_b() && !this.itemstack_recipe_match(needed, palced)) {
                    return slots;
                }
                if (needed.func_190926_b()) continue;
                stack_sizes[i2] = palced.func_190916_E();
            }
            int min_placed = 64;
            int max_placed = 0;
            for (int i3 = 0; i3 < 9; ++i3) {
                if (stack_sizes[i3] < 0) continue;
                min_placed = Math.min(min_placed, stack_sizes[i3]);
                max_placed = Math.max(max_placed, stack_sizes[i3]);
            }
            int fillup_size = max_placed <= min_placed ? min_placed + 1 : max_placed;
            for (i = 0; i < 9; ++i) {
                if (stack_sizes[i] < 0 || fillup_size <= this.func_70301_a(i + 0).func_77976_d()) continue;
                return slots;
            }
            for (i = 0; i < 9; ++i) {
                if (stack_sizes[i] < 0) {
                    slots.add(ItemStack.field_190927_a);
                    continue;
                }
                ItemStack st = this.func_70301_a(i + 0).func_77946_l();
                if (st.func_190926_b()) {
                    st = tocraft.get(i + 1).func_77946_l();
                    st.func_190920_e(Math.min(st.func_77976_d(), fillup_size));
                } else {
                    st.func_190920_e(MathHelper.func_76125_a((int)(fillup_size - st.func_190916_E()), (int)0, (int)st.func_77976_d()));
                }
                slots.add(st);
            }
            return slots;
        }

        private List<ItemStack> incr_crafting_grid_stacks(int count) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                ItemStack palced = this.func_70301_a(i + 0).func_77946_l();
                if (!palced.func_190926_b()) {
                    palced.func_190920_e(count);
                }
                stacks.add(palced);
            }
            return stacks;
        }

        private ItemStack move_stack_to_inventory(ItemStack stack_to_move, SlotRange range, boolean only_fillup, int limit) {
            int nmax;
            ItemStack stack;
            int i;
            IInventory inventory = range.inventory;
            int slot_begin = range.start_slot;
            int slot_end = range.end_slot;
            ItemStack mvstack = stack_to_move.func_77946_l();
            if (mvstack.func_190926_b() || slot_begin < 0 || slot_end > inventory.func_70302_i_()) {
                return mvstack;
            }
            int limit_left = limit > 0 ? Math.min(limit, mvstack.func_77976_d()) : mvstack.func_77976_d();
            for (i = slot_begin; i < slot_end; ++i) {
                stack = inventory.func_70301_a(i);
                if (stack.func_190926_b() || !stack.func_77969_a(mvstack)) continue;
                nmax = Math.min(limit_left, stack.func_77976_d() - stack.func_190916_E());
                if (mvstack.func_190916_E() <= nmax) {
                    stack.func_190920_e(stack.func_190916_E() + mvstack.func_190916_E());
                    mvstack.func_190920_e(0);
                    inventory.func_70299_a(i, stack);
                    return mvstack;
                }
                stack.func_190917_f(nmax);
                mvstack.func_190918_g(nmax);
                inventory.func_70299_a(i, stack);
                limit_left -= nmax;
            }
            if (only_fillup) {
                return mvstack;
            }
            if (inventory instanceof InventoryPlayer) {
                for (i = slot_begin + 1; i < slot_end - 1; ++i) {
                    stack = inventory.func_70301_a(i);
                    if (!stack.func_190926_b() || !inventory.func_70301_a(i + 1).func_77969_a(mvstack) && !inventory.func_70301_a(i - 1).func_77969_a(mvstack)) continue;
                    nmax = Math.min(limit_left, mvstack.func_190916_E());
                    ItemStack placed = mvstack.func_77946_l();
                    placed.func_190920_e(nmax);
                    mvstack.func_190918_g(nmax);
                    inventory.func_70299_a(i, placed);
                    return mvstack;
                }
            }
            for (i = slot_begin; i < slot_end; ++i) {
                stack = inventory.func_70301_a(i);
                if (!stack.func_190926_b()) continue;
                nmax = Math.min(limit_left, mvstack.func_190916_E());
                ItemStack placed = mvstack.func_77946_l();
                placed.func_190920_e(nmax);
                mvstack.func_190918_g(nmax);
                inventory.func_70299_a(i, placed);
                return mvstack;
            }
            return mvstack;
        }

        private boolean isItemExactlyEqual(ItemStack stack1, ItemStack stack2) {
            int n;
            NBTTagCompound nbt;
            if (!stack1.func_77969_a(stack2)) {
                return false;
            }
            if (stack1.func_77942_o()) {
                nbt = stack1.func_77978_p();
                n = stack1.func_77978_p().func_186856_d();
                if (n > 0 && stack1.func_77973_b().func_77645_m() && stack1.func_77978_p().func_74764_b("Damage")) {
                    --n;
                }
                if (n > 0) {
                    return false;
                }
            }
            if (stack2.func_77942_o()) {
                nbt = stack2.func_77978_p();
                n = stack2.func_77978_p().func_186856_d();
                if (n > 0 && stack2.func_77973_b().func_77645_m() && stack2.func_77978_p().func_74764_b("Damage")) {
                    --n;
                }
                if (n > 0) {
                    return false;
                }
            }
            return true;
        }

        private ItemStack move_stack_from_inventory(SlotRange range, ItemStack request_stack) {
            int n;
            IInventory inventory = range.inventory;
            int slot_begin = range.start_slot;
            int slot_end = range.end_slot;
            ItemStack fetched_stack = request_stack.func_77946_l();
            fetched_stack.func_190920_e(0);
            for (int n_left = request_stack.func_190916_E(); n_left > 0; n_left -= n) {
                int smallest_stack_size = 0;
                int smallest_stack_index = -1;
                for (int i = slot_begin; i < slot_end; ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190926_b() || !stack.func_77969_a(request_stack)) continue;
                    if (stack.func_77942_o()) {
                        NBTTagCompound nbt = stack.func_77978_p();
                        int n2 = nbt.func_186856_d();
                        if (n2 > 0 && nbt.func_74764_b("Damage")) {
                            --n2;
                        }
                        if (n2 > 0) continue;
                    }
                    fetched_stack = stack.func_77946_l();
                    fetched_stack.func_190920_e(0);
                    int n3 = stack.func_190916_E();
                    if (n3 >= smallest_stack_size && smallest_stack_size > 0) continue;
                    smallest_stack_size = n3;
                    smallest_stack_index = i;
                }
                if (smallest_stack_index < 0) break;
                n = Math.min(n_left, smallest_stack_size);
                fetched_stack.func_190917_f(n);
                ItemStack st = inventory.func_70301_a(smallest_stack_index);
                st.func_190918_g(n);
                inventory.func_70299_a(smallest_stack_index, st);
            }
            return fetched_stack;
        }

        private boolean clear_grid_to_storage(EntityPlayer player) {
            boolean changed = false;
            for (int grid_i = 0; grid_i < 9; ++grid_i) {
                ItemStack stack = this.func_70301_a(grid_i);
                if (stack.func_190926_b()) continue;
                ItemStack remaining = this.move_stack_to_inventory(stack, new SlotRange(this, 9, 17), false, 0);
                this.func_70299_a(grid_i, remaining);
                changed = true;
            }
            return changed;
        }

        private boolean clear_grid_to_player(EntityPlayer player) {
            boolean changed = false;
            for (int grid_i = 0; grid_i < 9; ++grid_i) {
                ItemStack remaining = this.func_70301_a(grid_i);
                if (remaining.func_190926_b()) continue;
                remaining = this.move_stack_to_inventory(remaining, new SlotRange((IInventory)player.field_71071_by, 9, 36), true, 0);
                remaining = this.move_stack_to_inventory(remaining, new SlotRange((IInventory)player.field_71071_by, 0, 9), true, 0);
                remaining = this.move_stack_to_inventory(remaining, new SlotRange((IInventory)player.field_71071_by, 9, 36), false, 0);
                remaining = this.move_stack_to_inventory(remaining, new SlotRange((IInventory)player.field_71071_by, 0, 9), false, 0);
                this.func_70299_a(grid_i, remaining);
                changed = true;
            }
            return changed;
        }

        private PlacementResult place_stacks(SlotRange[] ranges, List<ItemStack> to_fill, @Nullable EntityPlayer player) {
            boolean slots_changed = false;
            if (!to_fill.isEmpty()) {
                block0: for (SlotRange slot_range : ranges) {
                    for (int it_guard = 63; it_guard >= 0; --it_guard) {
                        boolean slots_updated = false;
                        for (int i = 0; i < 9; ++i) {
                            ItemStack grid_stack;
                            if (to_fill.get(i).func_190926_b() || (grid_stack = this.func_70301_a(i + 0).func_77946_l()).func_190916_E() >= grid_stack.func_77976_d()) continue;
                            ItemStack req_stack = to_fill.get(i).func_77946_l();
                            req_stack.func_190920_e(1);
                            ItemStack mv_stack = this.move_stack_from_inventory(slot_range, req_stack);
                            if (mv_stack.func_190926_b()) continue;
                            to_fill.get(i).func_190918_g(1);
                            if (grid_stack.func_190926_b()) {
                                grid_stack = mv_stack.func_77946_l();
                            } else {
                                grid_stack.func_190917_f(mv_stack.func_190916_E());
                            }
                            this.func_70299_a(i + 0, grid_stack);
                            slots_changed = true;
                            slots_updated = true;
                        }
                        if (!slots_updated) continue block0;
                    }
                }
            }
            boolean missing_item = false;
            for (ItemStack st : to_fill) {
                if (st.func_190926_b()) continue;
                missing_item = true;
                break;
            }
            if (this.history.current_recipe() != null && player != null && player.field_71070_bA instanceof BContainer) {
                ((BContainer)player.field_71070_bA).craftResult.func_193056_a(this.history.current_recipe());
            }
            if (!slots_changed) {
                return PlacementResult.UNCHANGED;
            }
            if (missing_item) {
                return PlacementResult.INCOMPLETE;
            }
            return PlacementResult.PLACED;
        }

        private PlacementResult distribute_stack(IInventory inventory, int slotno) {
            List<ItemStack> to_refab = this.refab_crafting_stacks();
            ItemStack to_distribute = inventory.func_70301_a(slotno).func_77946_l();
            if (to_distribute.func_190926_b()) {
                return PlacementResult.UNCHANGED;
            }
            int[] matching_grid_stack_sizes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
            int max_matching_stack_size = -1;
            int min_matching_stack_size = 65;
            int total_num_missing_stacks = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack refab_stack;
                ItemStack grid_stack = this.func_70301_a(i + 0);
                ItemStack itemStack = refab_stack = to_refab.isEmpty() ? ItemStack.field_190927_a : to_refab.get(i).func_77946_l();
                if (!grid_stack.func_190926_b() && this.isItemExactlyEqual(grid_stack, to_distribute)) {
                    matching_grid_stack_sizes[i] = grid_stack.func_190916_E();
                    total_num_missing_stacks += grid_stack.func_77976_d() - grid_stack.func_190916_E();
                    if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                        max_matching_stack_size = matching_grid_stack_sizes[i];
                    }
                    if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                    min_matching_stack_size = matching_grid_stack_sizes[i];
                    continue;
                }
                if (!refab_stack.func_190926_b() && this.isItemExactlyEqual(refab_stack, to_distribute)) {
                    matching_grid_stack_sizes[i] = 0;
                    total_num_missing_stacks += grid_stack.func_77976_d();
                    if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                        max_matching_stack_size = matching_grid_stack_sizes[i];
                    }
                    if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                    min_matching_stack_size = matching_grid_stack_sizes[i];
                    continue;
                }
                if (!grid_stack.func_190926_b() || refab_stack.func_190926_b() || !this.itemstack_recipe_match(to_distribute, refab_stack)) continue;
                matching_grid_stack_sizes[i] = 0;
                total_num_missing_stacks += grid_stack.func_77976_d();
                if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                    max_matching_stack_size = matching_grid_stack_sizes[i];
                }
                if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                min_matching_stack_size = matching_grid_stack_sizes[i];
            }
            if (min_matching_stack_size < 0) {
                return PlacementResult.UNCHANGED;
            }
            int stack_limit_size = Math.min(to_distribute.func_77976_d(), this.func_70297_j_());
            if (min_matching_stack_size >= stack_limit_size) {
                return PlacementResult.UNCHANGED;
            }
            int n_to_distribute = to_distribute.func_190916_E();
            for (int it_guard = 63; it_guard >= 0 && n_to_distribute > 0; --it_guard) {
                for (int i = 0; i < 9 && n_to_distribute > 0; ++i) {
                    if (matching_grid_stack_sizes[i] != min_matching_stack_size) continue;
                    int n = i;
                    matching_grid_stack_sizes[n] = matching_grid_stack_sizes[n] + 1;
                    --n_to_distribute;
                }
                if (min_matching_stack_size < max_matching_stack_size) {
                    ++min_matching_stack_size;
                } else {
                    max_matching_stack_size = ++min_matching_stack_size;
                }
                if (min_matching_stack_size >= stack_limit_size) break;
            }
            if (n_to_distribute == to_distribute.func_190916_E()) {
                return PlacementResult.UNCHANGED;
            }
            if (n_to_distribute <= 0) {
                inventory.func_70299_a(slotno, ItemStack.field_190927_a);
            } else {
                to_distribute.func_190920_e(n_to_distribute);
                inventory.func_70299_a(slotno, to_distribute);
            }
            for (int i = 0; i < 9; ++i) {
                if (matching_grid_stack_sizes[i] < 0) continue;
                ItemStack grid_stack = this.func_70301_a(i + 0).func_77946_l();
                if (grid_stack.func_190926_b()) {
                    grid_stack = to_distribute.func_77946_l();
                }
                grid_stack.func_190920_e(matching_grid_stack_sizes[i]);
                this.func_70299_a(i + 0, grid_stack);
            }
            return PlacementResult.PLACED;
        }

        private boolean decrease_grid_stacks(SlotRange[] ranges, int limit) {
            boolean changed = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.func_70301_a(i + 0).func_77946_l();
                if (stack.func_190926_b()) continue;
                for (SlotRange range : ranges) {
                    ItemStack remaining = this.move_stack_to_inventory(stack, range, false, limit);
                    if (remaining.func_190916_E() < stack.func_190916_E()) {
                        changed = true;
                    }
                    boolean stop = remaining.func_190916_E() <= Math.max(0, stack.func_190916_E() - limit);
                    stack = remaining;
                    if (stop) break;
                }
                this.func_70299_a(i + 0, stack.func_190926_b() ? ItemStack.field_190927_a : stack);
            }
            return changed;
        }

        private boolean increase_grid_stacks(SlotRange[] ranges, int limit, EntityPlayer player) {
            return this.place_stacks(ranges, this.incr_crafting_grid_stacks(limit), player) != PlacementResult.UNCHANGED;
        }

        @Override
        public void onClientPacketReceived(EntityPlayer player, NBTTagCompound nbt) {
            if (this.field_145850_b.field_72995_K || !(player.field_71070_bA instanceof BContainer)) {
                return;
            }
            BContainer container = (BContainer)player.field_71070_bA;
            if (container.te != this) {
                return;
            }
            boolean te_changed = false;
            boolean player_inventory_changed = false;
            if (with_assist && nbt.func_74764_b("action")) {
                switch (nbt.func_74762_e("action")) {
                    case 0: {
                        this.history.next();
                        this.syncHistory(player);
                        if (this.clear_grid_to_player(player)) {
                            te_changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        te_changed = true;
                        break;
                    }
                    case 1: {
                        this.history.prev();
                        this.syncHistory(player);
                        if (this.clear_grid_to_player(player)) {
                            te_changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        te_changed = true;
                        break;
                    }
                    case 2: {
                        this.history.reset_selection();
                        this.syncHistory(player);
                        if (this.clear_grid_to_player(player)) {
                            te_changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        te_changed = true;
                        break;
                    }
                    case 5: {
                        if (!this.clear_grid_to_storage(player)) break;
                        te_changed = true;
                        break;
                    }
                    case 7: {
                        if (!this.clear_grid_to_player(player)) break;
                        te_changed = true;
                        player_inventory_changed = true;
                        break;
                    }
                    case 4: {
                        if (this.place_stacks(new SlotRange[]{new SlotRange(this, 9, 17)}, this.refab_crafting_stacks(), player) == PlacementResult.UNCHANGED) break;
                        te_changed = true;
                        break;
                    }
                    case 6: {
                        if (this.place_stacks(new SlotRange[]{new SlotRange((IInventory)player.field_71071_by, 9, 36), new SlotRange((IInventory)player.field_71071_by, 0, 9)}, this.refab_crafting_stacks(), player) == PlacementResult.UNCHANGED) break;
                        te_changed = true;
                        player_inventory_changed = true;
                        break;
                    }
                    case 8: {
                        if (this.place_stacks(new SlotRange[]{new SlotRange((IInventory)player.field_71071_by, 0, 9), new SlotRange((IInventory)player.field_71071_by, 9, 36), new SlotRange(this, 9, 17)}, this.refab_crafting_stacks(), player) == PlacementResult.UNCHANGED) break;
                        te_changed = true;
                        break;
                    }
                    case 9: {
                        ItemStack stack;
                        int container_slot_id = nbt.func_74762_e("containerslot");
                        if (container_slot_id < 10 || container_slot_id > 53) break;
                        if (container_slot_id >= 46) {
                            int storage_slot = container_slot_id - 46 + 9;
                            PlacementResult stat = this.distribute_stack(this, storage_slot);
                            if (stat == PlacementResult.UNCHANGED) break;
                            te_changed = true;
                            break;
                        }
                        int player_slot = container_slot_id >= 37 ? container_slot_id - 37 : container_slot_id - 10 + 9;
                        ItemStack reference_stack = player.field_71071_by.func_70301_a(player_slot).func_77946_l();
                        if (reference_stack.func_190926_b() || this.distribute_stack((IInventory)player.field_71071_by, player_slot) == PlacementResult.UNCHANGED) break;
                        player_inventory_changed = true;
                        te_changed = true;
                        if (!nbt.func_74764_b("move-all")) break;
                        for (int i = 0; !(i >= player.field_71071_by.func_70302_i_() || reference_stack.func_77969_a(stack = player.field_71071_by.func_70301_a(i)) && this.distribute_stack((IInventory)player.field_71071_by, i) == PlacementResult.UNCHANGED); ++i) {
                        }
                        break;
                    }
                    case 10: {
                        SlotRange[] to_ranges;
                        int from_slot;
                        BTileEntity from_inventory;
                        int container_slot_id = nbt.func_74762_e("containerslot");
                        if (container_slot_id < 1 || container_slot_id > 53) break;
                        if (container_slot_id < 10) {
                            if (this.clear_grid_to_player(player)) {
                                te_changed = true;
                                player_inventory_changed = true;
                            }
                            if (!this.clear_grid_to_storage(player)) break;
                            te_changed = true;
                            break;
                        }
                        if (container_slot_id >= 46) {
                            from_inventory = this;
                            from_slot = container_slot_id - 46 + 9;
                            to_ranges = new SlotRange[]{new SlotRange((IInventory)player.field_71071_by, 9, 36), new SlotRange((IInventory)player.field_71071_by, 0, 9)};
                        } else {
                            from_inventory = player.field_71071_by;
                            from_slot = container_slot_id >= 37 ? container_slot_id - 37 : container_slot_id - 10 + 9;
                            to_ranges = new SlotRange[]{new SlotRange(this, 9, 17)};
                        }
                        ItemStack reference_stack = from_inventory.func_70301_a(from_slot).func_77946_l();
                        if (reference_stack.func_190926_b()) break;
                        boolean abort = false;
                        for (int i = 0; i < from_inventory.func_70302_i_() && !abort; ++i) {
                            ItemStack stack = from_inventory.func_70301_a(i);
                            if (!reference_stack.func_77969_a(stack)) continue;
                            ItemStack remaining = from_inventory.func_70301_a(i);
                            for (SlotRange range : to_ranges) {
                                if (!(remaining = this.move_stack_to_inventory(remaining, range, false, 0)).func_190926_b()) {
                                    abort = true;
                                    break;
                                }
                                player_inventory_changed = true;
                                te_changed = true;
                            }
                            from_inventory.func_70299_a(i, remaining);
                        }
                        break;
                    }
                    case 3: {
                        if (!(player.field_71070_bA instanceof BContainer)) break;
                        ((BContainer)player.field_71070_bA).select_next_collision_recipe(this, player);
                        break;
                    }
                    case 12: {
                        te_changed = player_inventory_changed = this.decrease_grid_stacks(new SlotRange[]{new SlotRange((IInventory)player.field_71071_by, 9, 36), new SlotRange((IInventory)player.field_71071_by, 0, 9), new SlotRange(this, 9, 17)}, MathHelper.func_76125_a((int)nbt.func_74762_e("limit"), (int)1, (int)8));
                        break;
                    }
                    case 11: {
                        te_changed = player_inventory_changed = this.increase_grid_stacks(new SlotRange[]{new SlotRange((IInventory)player.field_71071_by, 9, 36), new SlotRange((IInventory)player.field_71071_by, 0, 9), new SlotRange(this, 9, 17)}, MathHelper.func_76125_a((int)nbt.func_74762_e("limit"), (int)1, (int)8), player);
                    }
                }
            }
            if (te_changed) {
                this.func_70296_d();
            }
            if (player_inventory_changed) {
                player.field_71071_by.func_70296_d();
            }
            if (te_changed || player_inventory_changed) {
                container.func_75130_a(this);
                container.func_75142_b();
            }
        }

        @Override
        public void onServerPacketReceived(NBTTagCompound nbt) {
            if (nbt.func_74764_b("historydata")) {
                this.history.read(nbt.func_74775_l("historydata"));
            }
            if (nbt.func_74764_b("hascollision")) {
                this.has_recipe_collision_ = nbt.func_74767_n("hascollision");
            }
        }

        private void syncHistory(EntityPlayer player) {
            if (!with_assist) {
                return;
            }
            NBTTagCompound history_nbt = new NBTTagCompound();
            this.history.write(history_nbt);
            NBTTagCompound rnbt = new NBTTagCompound();
            rnbt.func_74782_a("historydata", (NBTBase)history_nbt);
            rnbt.func_74757_a("hascollision", this.has_recipe_collision_);
            Networking.PacketTileNotify.sendToPlayer(player, this, rnbt);
        }

        private void syncProperties(EntityPlayer player) {
            if (!with_assist) {
                return;
            }
            NBTTagCompound rnbt = new NBTTagCompound();
            rnbt.func_74757_a("hascollision", this.has_recipe_collision_);
            Networking.PacketTileNotify.sendToPlayer(player, this, rnbt);
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorCraftingTable);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public NBTTagCompound func_189517_E_() {
            NBTTagCompound nbt = new NBTTagCompound();
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
            super.func_145839_a(pkt.func_148857_g());
            this.readnbt(pkt.func_148857_g());
            super.onDataPacket(net, pkt);
        }

        public SPacketUpdateTileEntity func_189518_D_() {
            return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
        }

        public void handleUpdateTag(NBTTagCompound tag) {
            this.func_145839_a(tag);
        }

        @SideOnly(value=Side.CLIENT)
        public double func_145833_n() {
            return 400.0;
        }

        public String func_70005_c_() {
            Block block = this.func_145838_q();
            return block != null ? block.func_149739_a() + ".name" : "";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return this.stacks.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks.set(index, (Object)stack);
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
            this.stacks.clear();
        }

        static enum PlacementResult {
            UNCHANGED,
            INCOMPLETE,
            PLACED;

        }
    }

    private static class SlotRange {
        public final IInventory inventory;
        public int start_slot;
        public int end_slot;

        public SlotRange(IInventory inv, int start, int end) {
            this.inventory = inv;
            this.start_slot = start;
            this.end_slot = end;
        }
    }

    private static class BInventoryCrafting
    extends InventoryCrafting {
        protected final Container container;
        protected final IInventory inventory;

        public BInventoryCrafting(Container container_, IInventory inventory_te) {
            super(container_, 3, 3);
            this.container = container_;
            this.inventory = inventory_te;
        }

        public int func_70302_i_() {
            return 9;
        }

        public void func_174889_b(EntityPlayer player) {
            this.inventory.func_174889_b(player);
        }

        public void func_174886_c(EntityPlayer player) {
            this.inventory.func_174886_c(player);
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(index, stack);
            this.container.func_75130_a((IInventory)this);
        }

        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = this.inventory.func_70298_a(index, count);
            if (!stack.func_190926_b()) {
                this.container.func_75130_a((IInventory)this);
            }
            return stack;
        }
    }

    public static class BContainer
    extends Container {
        protected static final int BUTTON_NEXT = 0;
        protected static final int BUTTON_PREV = 1;
        protected static final int BUTTON_CLEAR_GRID = 2;
        protected static final int BUTTON_NEXT_COLLISION_RECIPE = 3;
        protected static final int BUTTON_FROM_STORAGE = 4;
        protected static final int BUTTON_TO_STORAGE = 5;
        protected static final int BUTTON_FROM_PLAYER = 6;
        protected static final int BUTTON_TO_PLAYER = 7;
        protected static final int ACTION_PLACE_CURRENT_HISTORY_SEL = 8;
        protected static final int ACTION_PLACE_SHIFTCLICKED_STACK = 9;
        protected static final int ACTION_MOVE_ALL_STACKS = 10;
        protected static final int ACTION_INCREASE_CRAFTING_STACKS = 11;
        protected static final int ACTION_DECREASE_CRAFTING_STACKS = 12;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        public BInventoryCrafting craftMatrix;
        public InventoryCraftResult craftResult = new InventoryCraftResult();
        public final ImmutableList<Tuple<Integer, Integer>> CRAFTING_SLOT_POSITIONS;

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            int x;
            int y;
            ArrayList<Tuple> slotpositions = new ArrayList<Tuple>();
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            this.craftMatrix = new BInventoryCrafting(this, te);
            this.craftMatrix.func_174889_b(this.player);
            this.func_75146_a((Slot)new BSlotCrafting(te, playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 134, 35));
            slotpositions.add(new Tuple((Object)134, (Object)35));
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    int xpos = 60 + x * 18;
                    int ypos = 17 + y * 18;
                    this.func_75146_a(new Slot((IInventory)this.craftMatrix, x + y * 3, xpos, ypos));
                    slotpositions.add(new Tuple((Object)xpos, (Object)ypos));
                }
            }
            this.CRAFTING_SLOT_POSITIONS = ImmutableList.copyOf(slotpositions);
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x2, 8 + x2 * 18, 144));
            }
            for (y = 0; y < 4; ++y) {
                for (x = 0; x < 2; ++x) {
                    this.func_75146_a(new Slot((IInventory)this.craftMatrix, x + y * 2 + 9, 8 + x * 18, 9 + y * 18));
                }
            }
            this.func_75130_a((IInventory)this.craftMatrix);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorCraftingTable && player.func_174818_b(this.pos) <= 64.0;
        }

        public void func_75130_a(IInventory inv) {
            if (this.world.field_72995_K) {
                return;
            }
            try {
                BInventoryCrafting grid = this.craftMatrix;
                InventoryCraftResult result = this.craftResult;
                EntityPlayerMP pl = (EntityPlayerMP)this.player;
                ItemStack stack = ItemStack.field_190927_a;
                ArrayList<IRecipe> matching_recipes = new ArrayList<IRecipe>();
                IRecipe current_recipe = result.func_193055_i();
                ItemStack current_recipe_stack = result.func_70301_a(0);
                IRecipe current_recipe_matching = null;
                for (IRecipe r : CraftingManager.field_193380_a) {
                    if (r == null || !r.func_77569_a((InventoryCrafting)grid, this.world) || !r.func_192399_d() && this.world.func_82736_K().func_82766_b("doLimitedCrafting") && !pl.func_192037_E().func_193830_f(r)) continue;
                    matching_recipes.add(r);
                    ItemStack recipe_result_stack = r.func_77572_b((InventoryCrafting)grid);
                    if (r != current_recipe && !recipe_result_stack.func_77969_a(current_recipe_stack)) continue;
                    current_recipe_matching = r;
                }
                boolean bl = this.te.has_recipe_collision_ = matching_recipes.size() > 1;
                if (matching_recipes.size() > 0) {
                    if (current_recipe_matching == null) {
                        current_recipe_matching = (IRecipe)matching_recipes.get(0);
                    }
                    result.func_193056_a(current_recipe_matching);
                    stack = current_recipe_matching.func_77572_b((InventoryCrafting)grid);
                }
                result.func_70299_a(0, stack);
                pl.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, stack));
                this.te.syncProperties(this.player);
            }
            catch (Throwable exc) {
                ModEngineersDecor.logger.error("Recipe failed:", exc);
            }
        }

        public void func_75134_a(EntityPlayer player) {
            this.craftMatrix.func_174886_c(player);
            this.craftResult.func_174888_l();
            this.craftResult.func_174886_c(player);
            if (player != null) {
                for (Slot e : player.field_71069_bz.field_75151_b) {
                    if (!(e instanceof SlotCrafting)) continue;
                    ((SlotCrafting)e).func_75215_d(ItemStack.field_190927_a);
                }
            }
        }

        public boolean func_94530_a(ItemStack stack, Slot slot) {
            return slot.field_75224_c != this.craftResult && super.func_94530_a(stack, slot);
        }

        public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slotstack = slot.func_75211_c();
            ItemStack stack = slotstack.func_77946_l();
            if (index == 0) {
                slotstack.func_77973_b().func_77622_d(slotstack, this.world, playerIn);
                if (!this.func_75135_a(slotstack, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotstack, stack);
            } else if (index >= 10 && index < 46 ? !this.func_75135_a(slotstack, 46, 54, false) : (index >= 46 && index < 54 ? !this.func_75135_a(slotstack, 10, 46, false) : !this.func_75135_a(slotstack, 10, 46, false))) {
                return ItemStack.field_190927_a;
            }
            if (slotstack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotstack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, slotstack);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
            return stack;
        }

        public void setCraftingMatrixSlot(int slot_index, ItemStack stack) {
            this.craftMatrix.func_70299_a(slot_index, stack.func_77946_l());
        }

        public void select_next_collision_recipe(IInventory inv, EntityPlayer player) {
            if (this.world.field_72995_K) {
                return;
            }
            try {
                EntityPlayerMP pl = (EntityPlayerMP)player;
                ArrayList<IRecipe> matching_recipes = new ArrayList<IRecipe>();
                IRecipe current_recipe = this.craftResult.func_193055_i();
                ItemStack current_recipe_stack = this.craftResult.func_70301_a(0);
                int next_recipe_index = 0;
                for (IRecipe r : CraftingManager.field_193380_a) {
                    if (r == null || !r.func_77569_a((InventoryCrafting)this.craftMatrix, this.world) || !r.func_192399_d() && this.world.func_82736_K().func_82766_b("doLimitedCrafting") && !pl.func_192037_E().func_193830_f(r)) continue;
                    matching_recipes.add(r);
                    ItemStack recipe_result_stack = r.func_77572_b((InventoryCrafting)this.craftMatrix);
                    if (r != current_recipe && !recipe_result_stack.func_77969_a(current_recipe_stack)) continue;
                    next_recipe_index = matching_recipes.size();
                }
                IRecipe next_recipe = (IRecipe)matching_recipes.get(next_recipe_index >= matching_recipes.size() ? 0 : next_recipe_index);
                this.craftResult.func_70299_a(0, next_recipe.func_77572_b((InventoryCrafting)this.craftMatrix));
                this.craftResult.func_193056_a(next_recipe);
                this.func_75130_a(inv);
            }
            catch (Throwable exc) {
                ModEngineersDecor.logger.error("Recipe failed:", exc);
            }
        }
    }

    public static class BSlotCrafting
    extends SlotCrafting {
        private final BTileEntity te;
        private final EntityPlayer player;

        public BSlotCrafting(BTileEntity te, EntityPlayer player, InventoryCrafting craftingInventory, IInventory inventoryIn, int slotIndex, int xPosition, int yPosition) {
            super(player, craftingInventory, inventoryIn, slotIndex, xPosition, yPosition);
            this.te = te;
            this.player = player;
        }

        protected void func_75208_c(ItemStack stack) {
            if (with_assist && this.player.field_70170_p != null && !this.player.field_70170_p.field_72995_K && !stack.func_190926_b()) {
                IRecipe recipe = ((InventoryCraftResult)this.field_75224_c).func_193055_i();
                ArrayList<ItemStack> grid = new ArrayList<ItemStack>();
                grid.add(stack);
                for (int i = 0; i < 9; ++i) {
                    grid.add((ItemStack)this.te.stacks.get(i));
                }
                this.te.history.add(grid, recipe);
                this.te.history.reset_current();
                this.te.syncHistory(this.player);
            }
            super.func_75208_c(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class BGui
    extends GuiContainer {
        protected static final ResourceLocation BACKGROUND = new ResourceLocation("engineersdecor", "textures/gui/treated_wood_crafting_table.png");
        protected final BTileEntity te;
        protected final EntityPlayer player;
        protected final ArrayList<GuiButton> buttons = new ArrayList();
        protected final boolean[] history_slot_tooltip = new boolean[]{false, false, false, false, false, false, false, false, false, false};

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
            this.player = playerInventory.field_70458_d;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            this.buttons.clear();
            if (with_assist) {
                this.buttons.add(this.func_189646_b((GuiButton)new GuiButtonImage(0, x0 + 158, y0 + 44, 12, 12, 194, 44, 12, BACKGROUND)));
                this.buttons.add(this.func_189646_b((GuiButton)new GuiButtonImage(1, x0 + 158, y0 + 30, 12, 12, 180, 30, 12, BACKGROUND)));
                this.buttons.add(this.func_189646_b((GuiButton)new GuiButtonImage(2, x0 + 158, y0 + 58, 12, 12, 194, 8, 12, BACKGROUND)));
                this.buttons.add(this.func_189646_b((GuiButton)new GuiButtonImage(3, x0 + 132, y0 + 18, 20, 10, 183, 95, 12, BACKGROUND)));
                if (with_assist_quickmove_buttons) {
                    this.buttons.add(this.func_189646_b((GuiButton)new GuiButtonImage(4, x0 + 49, y0 + 34, 9, 17, 219, 34, 17, BACKGROUND)));
                    this.buttons.add(this.func_189646_b((GuiButton)new GuiButtonImage(5, x0 + 49, y0 + 52, 9, 17, 208, 16, 17, BACKGROUND)));
                    this.buttons.add(this.func_189646_b((GuiButton)new GuiButtonImage(6, x0 + 77, y0 + 71, 17, 9, 198, 71, 9, BACKGROUND)));
                    this.buttons.add(this.func_189646_b((GuiButton)new GuiButtonImage(7, x0 + 59, y0 + 71, 17, 9, 180, 71, 9, BACKGROUND)));
                }
            }
        }

        public void func_146274_d() throws IOException {
            super.func_146274_d();
            int wheel = Mouse.getDWheel();
            if (wheel != 0) {
                int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
                int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
                if (wheel != 0) {
                    this.mouseScrolled(x, y, wheel > 0 ? 1 : -1);
                }
            }
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            if (with_assist) {
                this.buttons.get((int)3).field_146125_m = this.te.has_recipe_collision();
                this.buttons.get((int)3).field_146124_l = this.te.has_recipe_collision();
            }
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_191948_b(int mouseX, int mouseY) {
            if (!this.player.field_71071_by.func_70445_o().func_190926_b() || this.getSlotUnderMouse() == null) {
                return;
            }
            Slot slot = this.getSlotUnderMouse();
            if (!slot.func_75211_c().func_190926_b()) {
                this.func_146285_a(slot.func_75211_c(), mouseX, mouseY);
                return;
            }
            if (with_assist) {
                int hist_index = -1;
                if (slot instanceof BSlotCrafting) {
                    hist_index = 0;
                } else if (slot.field_75224_c instanceof BInventoryCrafting) {
                    hist_index = slot.getSlotIndex() + 1;
                }
                if (hist_index < 0 || hist_index >= this.history_slot_tooltip.length) {
                    return;
                }
                if (!this.history_slot_tooltip[hist_index]) {
                    return;
                }
                ItemStack hist_stack = this.te.history.current().get(hist_index);
                if (!hist_stack.func_190926_b()) {
                    this.func_146285_a(hist_stack, mouseX, mouseY);
                }
            }
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73729_b(x0, y0, 0, 0, this.field_146999_f, this.field_147000_g);
            if (with_assist) {
                for (int i = 0; i < this.history_slot_tooltip.length; ++i) {
                    this.history_slot_tooltip[i] = false;
                }
                List<ItemStack> crafting_template = this.te.history.current();
                if (crafting_template == null || crafting_template.isEmpty()) {
                    return;
                }
                int i = 0;
                for (Tuple e : ((BContainer)this.field_147002_h).CRAFTING_SLOT_POSITIONS) {
                    if (i == 0) continue;
                    if (this.field_147002_h.func_75139_a(i).func_75216_d() && !this.field_147002_h.func_75139_a(i).func_75211_c().func_77969_a(crafting_template.get(i))) {
                        return;
                    }
                    ++i;
                }
                i = 0;
                for (Tuple e : ((BContainer)this.field_147002_h).CRAFTING_SLOT_POSITIONS) {
                    ItemStack stack = crafting_template.get(i);
                    if (!stack.func_190926_b()) {
                        if (!this.field_147002_h.func_75139_a(i).func_75216_d()) {
                            this.history_slot_tooltip[i] = true;
                        }
                        if (i == 0 && this.field_147002_h.func_75139_a(i).func_75211_c().func_77969_a(crafting_template.get(i))) continue;
                        this.drawTemplateItemAt(stack, x0, y0, (Integer)e.func_76341_a(), (Integer)e.func_76340_b());
                    }
                    ++i;
                }
            }
        }

        protected void drawTemplateItemAt(ItemStack stack, int x0, int y0, int x, int y) {
            float main_zl = this.field_73735_i;
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            float zl = this.field_146296_j.field_77023_b;
            this.field_146296_j.field_77023_b = -50.0f;
            this.field_146296_j.func_175042_a(stack, x0 + x, y0 + y);
            this.field_146296_j.field_77023_b = zl;
            this.field_73735_i = 100.0f;
            GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)0.7f, (float)0.8f);
            this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
            this.func_73729_b(x0 + x, y0 + y, x, y, 16, 16);
            RenderHelper.func_74520_c();
            RenderHelper.func_74519_b();
            this.field_73735_i = main_zl;
        }

        protected void func_146284_a(GuiButton button) {
            switch (button.field_146127_k) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("action", button.field_146127_k);
                    Networking.PacketTileNotify.sendToServer(this.te, nbt);
                    break;
                }
            }
        }

        protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
            if (type == ClickType.PICKUP) {
                boolean place_refab;
                boolean bl = place_refab = slot instanceof BSlotCrafting && !slot.func_75216_d();
                if (place_refab && with_assist_direct_history_refab) {
                    this.onHistoryItemPlacement();
                }
                super.func_184098_a(slot, slotId, mouseButton, type);
                if (place_refab && !with_assist_direct_history_refab) {
                    this.onHistoryItemPlacement();
                }
                return;
            }
            if (type == ClickType.QUICK_MOVE && slotId > 0 && slot.func_75216_d() && with_assist) {
                List<ItemStack> history = this.te.history.current();
                boolean palce_in_crafting_grid = false;
                if (slotId > 9) {
                    boolean bl = palce_in_crafting_grid = !history.isEmpty();
                    if (!palce_in_crafting_grid) {
                        for (int i = 0; i < 9; ++i) {
                            if (this.te.func_70301_a(i).func_190926_b()) continue;
                            palce_in_crafting_grid = true;
                            break;
                        }
                    }
                }
                if (palce_in_crafting_grid) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("action", 9);
                    nbt.func_74768_a("containerslot", slotId);
                    if (ModAuxiliaries.isCtrlDown()) {
                        nbt.func_74757_a("move-all", true);
                    }
                    Networking.PacketTileNotify.sendToServer(this.te, nbt);
                    return;
                }
                if (ModAuxiliaries.isCtrlDown()) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("action", 10);
                    nbt.func_74768_a("containerslot", slotId);
                    Networking.PacketTileNotify.sendToServer(this.te, nbt);
                    return;
                }
            }
            super.func_184098_a(slot, slotId, mouseButton, type);
        }

        private boolean mouseScrolled(int mouseX, int mouseY, int wheel_inc) {
            Slot resultSlot = this.getSlotUnderMouse();
            if (!with_crafting_slot_mouse_scrolling || !(resultSlot instanceof BSlotCrafting)) {
                return false;
            }
            int count = resultSlot.func_75211_c().func_190916_E();
            int limit = (ModAuxiliaries.isShiftDown() ? 2 : 1) * (ModAuxiliaries.isCtrlDown() ? 4 : 1);
            if (wheel_inc > 0) {
                if (count > 0) {
                    if (count < resultSlot.func_75211_c().func_77976_d() && count < resultSlot.func_75219_a()) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74768_a("action", 11);
                        if (limit > 1) {
                            nbt.func_74768_a("limit", limit);
                        }
                        Networking.PacketTileNotify.sendToServer(this.te, nbt);
                    }
                } else if (!this.te.history.current().isEmpty()) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("action", 8);
                    Networking.PacketTileNotify.sendToServer(this.te, nbt);
                }
            } else if (wheel_inc < 0 && count > 0) {
                NBTTagCompound nbt = new NBTTagCompound();
                if (limit > 1) {
                    nbt.func_74768_a("limit", limit);
                }
                nbt.func_74768_a("action", 12);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            }
            return true;
        }

        private void onHistoryItemPlacement() {
            if (this.te.history.current().isEmpty()) {
                return;
            }
            Slot resultSlot = this.getSlotUnderMouse();
            if (!(resultSlot instanceof BSlotCrafting)) {
                return;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("action", 8);
            Networking.PacketTileNotify.sendToServer(this.te, nbt);
        }
    }

    private static class CraftingHistory {
        public static final int RESULT_STACK_INDEX = 0;
        public static final int INPUT_STACKS_BEGIN = 1;
        public static final List<ItemStack> NOTHING = new ArrayList<ItemStack>();
        private static int max_history_size_ = 5;
        private List<String> history_ = new ArrayList<String>();
        private int current_ = -1;
        private List<ItemStack> current_stacks_ = new ArrayList<ItemStack>();
        private IRecipe current_recipe_ = null;

        public static int max_history_size() {
            return max_history_size_;
        }

        public static int max_history_size(int newsize) {
            max_history_size_ = MathHelper.func_76125_a((int)newsize, (int)0, (int)32);
            return max_history_size_;
        }

        public void read(NBTTagCompound nbt) {
            try {
                this.clear();
                NBTTagCompound subsect = nbt.func_74775_l("history");
                if (subsect.func_82582_d()) {
                    return;
                }
                String s = subsect.func_74779_i("elements");
                if (s != null && s.length() > 0) {
                    String[] ls;
                    for (String e : ls = s.split("[|]")) {
                        this.history_.add(e.toLowerCase().trim());
                    }
                }
                this.current_ = !subsect.func_74764_b("current") ? -1 : MathHelper.func_76125_a((int)subsect.func_74762_e("current"), (int)-1, (int)(this.history_.size() - 1));
                this.update_current();
            }
            catch (Throwable ex) {
                ModEngineersDecor.logger.error("Exception reading crafting table history NBT, resetting, exception is:" + ex.getMessage());
                this.clear();
            }
        }

        public void write(NBTTagCompound nbt) {
            NBTTagCompound subsect = new NBTTagCompound();
            subsect.func_74768_a("current", this.current_);
            subsect.func_74778_a("elements", String.join((CharSequence)"|", this.history_));
            nbt.func_74782_a("history", (NBTBase)subsect);
        }

        public void clear() {
            this.reset_current();
            this.history_.clear();
        }

        public void reset_current() {
            this.current_ = -1;
            this.current_stacks_ = NOTHING;
            this.current_recipe_ = null;
        }

        void update_current() {
            if (this.current_ < 0 || this.current_ >= this.history_.size()) {
                this.reset_current();
                return;
            }
            Tuple<IRecipe, List<ItemStack>> data = this.str2stacks(this.history_.get(this.current_));
            if (data == null) {
                this.reset_current();
                return;
            }
            this.current_recipe_ = (IRecipe)data.func_76341_a();
            this.current_stacks_ = (List)data.func_76340_b();
        }

        public void add(List<ItemStack> grid_stacks, IRecipe recipe) {
            if (!with_assist) {
                this.clear();
                return;
            }
            String s = this.stacks2str(grid_stacks, recipe);
            String recipe_filter = recipe.getRegistryName().toString() + ";";
            if (s.isEmpty()) {
                return;
            }
            this.history_.removeIf(e -> e.equals(s));
            this.history_.removeIf(e -> e.startsWith(recipe_filter));
            this.history_.add(s);
            while (this.history_.size() > CraftingHistory.max_history_size()) {
                this.history_.remove(0);
            }
            if (this.current_ >= this.history_.size()) {
                this.reset_current();
            }
        }

        public String stacks2str(List<ItemStack> grid_stacks, IRecipe recipe) {
            if (grid_stacks == null || grid_stacks.size() != 10 || recipe == null) {
                return "";
            }
            if (grid_stacks.get(0).func_190926_b()) {
                return "";
            }
            ArrayList<String> items = new ArrayList<String>();
            items.add(recipe.getRegistryName().toString().trim());
            for (ItemStack st : grid_stacks) {
                int meta = st.func_77960_j();
                items.add(st.func_190926_b() ? "" : st.func_77973_b().getRegistryName().toString().trim() + (meta == 0 ? "" : "/" + meta));
            }
            return String.join((CharSequence)";", items);
        }

        @Nullable
        public Tuple<IRecipe, List<ItemStack>> str2stacks(String entry) {
            try {
                if (entry == null || entry.isEmpty()) {
                    return null;
                }
                ArrayList<String> item_regnames = new ArrayList<String>(Arrays.asList(entry.split("[;]")));
                if (item_regnames == null || item_regnames.size() < 2 || item_regnames.size() > 11) {
                    return null;
                }
                while (item_regnames.size() < 11) {
                    item_regnames.add("");
                }
                IRecipe recipe = null;
                try {
                    IForgeRegistry recipe_registry = GameRegistry.findRegistry(IRecipe.class);
                    recipe = (IRecipe)recipe_registry.getValue(new ResourceLocation(item_regnames.remove(0)));
                }
                catch (Throwable e) {
                    ModEngineersDecor.logger.error("Recipe lookup failed: " + e.getMessage());
                }
                if (recipe == null) {
                    return null;
                }
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (String regname : item_regnames) {
                    ItemStack stack = ItemStack.field_190927_a;
                    if (!regname.isEmpty()) {
                        Item item;
                        int meta = 0;
                        if (regname.indexOf(47) >= 0) {
                            String[] itemdetails = regname.split("[/]");
                            if (itemdetails.length > 0) {
                                regname = itemdetails[0];
                            }
                            if (itemdetails.length > 1) {
                                try {
                                    meta = Integer.parseInt(itemdetails[1]);
                                }
                                catch (Throwable e) {
                                    meta = 0;
                                }
                            }
                        }
                        stack = (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(regname))) == null || item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack(item, 1, meta);
                    }
                    stacks.add(stack);
                }
                if (stacks.size() != 10 || ((ItemStack)stacks.get(0)).func_190926_b()) {
                    return null;
                }
                return new Tuple((Object)recipe, stacks);
            }
            catch (Throwable ex) {
                ModEngineersDecor.logger.error("History stack building failed: " + ex.getMessage());
                return null;
            }
        }

        public List<ItemStack> current() {
            return this.current_stacks_;
        }

        public IRecipe current_recipe() {
            return this.current_recipe_;
        }

        public void next() {
            this.current_ = this.history_.isEmpty() ? -1 : (++this.current_ >= this.history_.size() ? -1 : this.current_);
            this.update_current();
        }

        public void prev() {
            this.current_ = this.history_.isEmpty() ? -1 : (--this.current_ < -1 ? this.history_.size() - 1 : this.current_);
            this.update_current();
        }

        public void reset_selection() {
            this.current_ = -1;
            this.update_current();
        }

        public String toString() {
            String rec = this.current_recipe_ == null ? "none" : this.current_recipe_.getRegistryName().toString();
            StringBuilder s = new StringBuilder("{ current:" + this.current_ + ", recipe:'" + rec + "', elements:[ ");
            for (int i = 0; i < this.history_.size(); ++i) {
                s.append("{i:").append(i).append(", e:[").append(this.history_.get(i)).append("]} ");
            }
            s.append("]}");
            return s.toString();
        }
    }
}

