/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.detail.Networking;

public class BlockDecorPlacer
extends BlockDecorDirected {
    public BlockDecorPlacer(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
            return;
        }
        NBTTagCompound te_nbt = stack.func_77978_p().func_74775_l("tedata");
        if (te_nbt.func_82582_d()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).readnbt(te_nbt, false);
        ((BTileEntity)te).reset_rtstate();
        ((BTileEntity)te).func_70296_d();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        ItemStack stack = new ItemStack((Block)this, 1);
        NBTTagCompound te_nbt = new NBTTagCompound();
        ((BTileEntity)te).writenbt(te_nbt, false);
        if (!te_nbt.func_82582_d()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("tedata", (NBTBase)te_nbt);
            stack.func_77982_d(nbt);
        }
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        world.func_175698_g(pos);
        world.func_175713_t(pos);
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        for (ItemStack stack : ((BTileEntity)te).stacks_) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((BTileEntity)te).reset_rtstate();
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)ModEngineersDecor.instance, 213107, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        if (!(world instanceof World) || world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).block_updated();
    }

    public static Object getServerGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BContainer(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static Object getClientGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BGui(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    ISidedInventory,
    Networking.IPacketReceiver {
        public static final int TICK_INTERVAL = 40;
        public static final int NUM_OF_SLOTS = 18;
        public static final int LOGIC_INVERTED = 1;
        public static final int LOGIC_CONTINUOUS = 2;
        public static final int DEFAULT_LOGIC = 3;
        public static HashMap<ItemStack, SpecialPlacementFunction> special_placement_conversions = new HashMap();
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int logic_ = 3;
        private int current_slot_index_ = 0;
        private int tick_timer_ = 0;
        protected NonNullList<ItemStack> stacks_;
        private final IItemHandler item_handler_ = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
        private static final int[] SIDED_INV_SLOTS = new int[18];

        public static void on_config() {
            special_placement_conversions.put(new ItemStack(Items.field_151100_aR, 1, 3), (stack, world, pos) -> {
                if (world.func_180495_p(pos).func_177230_c() instanceof BlockCocoa) {
                    return EnumActionResult.PASS;
                }
                if (!Blocks.field_150375_by.func_176196_c(world, pos)) {
                    return EnumActionResult.FAIL;
                }
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    IBlockState st = world.func_180495_p(pos.func_177972_a(facing));
                    if (!(st.func_177230_c() instanceof BlockLog) || st.func_177230_c().func_176201_c(st) != 3) continue;
                    IBlockState state = Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_185512_D, (Comparable)facing);
                    return world.func_180501_a(pos, state, 3) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                }
                return EnumActionResult.FAIL;
            });
            ModEngineersDecor.logger.info("Config placer: " + special_placement_conversions.size() + " special placement handling entries.");
        }

        public BTileEntity() {
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            this.reset_rtstate();
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
        }

        public void readnbt(NBTTagCompound nbt, boolean update_packet) {
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks_);
            while (this.stacks_.size() < 18) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.block_power_signal_ = nbt.func_74767_n("powered");
            this.current_slot_index_ = nbt.func_74762_e("act_slot_index");
            this.logic_ = nbt.func_74764_b("logic") ? nbt.func_74762_e("logic") : 3;
        }

        protected void writenbt(NBTTagCompound nbt, boolean update_packet) {
            boolean stacks_not_empty = this.stacks_.stream().anyMatch(s -> !s.func_190926_b());
            if (stacks_not_empty) {
                ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks_);
            }
            if (this.block_power_signal_) {
                nbt.func_74757_a("powered", this.block_power_signal_);
            }
            if (stacks_not_empty) {
                nbt.func_74768_a("act_slot_index", this.current_slot_index_);
            }
            if (this.logic_ != 3) {
                nbt.func_74768_a("logic", this.logic_);
            }
        }

        public void block_updated() {
            boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            if (this.block_power_updated_) {
                this.tick_timer_ = 1;
            } else if (this.tick_timer_ > 4) {
                this.tick_timer_ = 4;
            }
        }

        public boolean is_input_slot(int index) {
            return index >= 0 && index < 18;
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorPlacer);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt, false);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public String func_70005_c_() {
            Block block = this.func_145838_q();
            return block != null ? block.func_149739_a() + ".name" : "";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            if (this.tick_timer_ > 8) {
                this.tick_timer_ = 8;
            }
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public int func_174887_a_(int id) {
            switch (id) {
                case 0: {
                    return this.logic_;
                }
                case 1: {
                    return this.block_power_signal_ ? 1 : 0;
                }
                case 2: {
                    return this.current_slot_index_;
                }
            }
            return 0;
        }

        public void func_174885_b(int id, int value) {
            switch (id) {
                case 0: {
                    this.logic_ = value;
                    return;
                }
                case 1: {
                    this.block_power_signal_ = value != 0;
                    return;
                }
                case 2: {
                    this.current_slot_index_ = MathHelper.func_76125_a((int)value, (int)0, (int)17);
                    return;
                }
            }
        }

        public int func_174890_g() {
            return 3;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int[] func_180463_a(EnumFacing side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
            return this.is_input_slot(index) && this.func_94041_b(index, stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            return false;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)this.item_handler_;
            }
            return (T)super.getCapability(capability, facing);
        }

        @Override
        public void onServerPacketReceived(NBTTagCompound nbt) {
        }

        @Override
        public void onClientPacketReceived(EntityPlayer player, NBTTagCompound nbt) {
            if (nbt.func_74764_b("logic")) {
                this.logic_ = nbt.func_74762_e("logic");
            }
            if (nbt.func_74764_b("manual_trigger") && nbt.func_74762_e("manual_trigger") != 0) {
                this.block_power_signal_ = true;
                this.block_power_updated_ = true;
                this.tick_timer_ = 1;
            }
            this.func_70296_d();
        }

        private static int next_slot(int i) {
            return i < 17 ? i + 1 : 0;
        }

        private boolean spit_out(EnumFacing facing) {
            ItemStack drop = ((ItemStack)this.stacks_.get(this.current_slot_index_)).func_77946_l();
            this.stacks_.set(this.current_slot_index_, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < 8; ++i) {
                BlockPos p = this.field_174879_c.func_177967_a(facing, i);
                if (!this.field_145850_b.func_175623_d(p)) continue;
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, drop));
                this.field_145850_b.func_184133_a(null, p, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.7f, 0.8f);
                break;
            }
            return true;
        }

        private static boolean place_item(ItemStack stack, EntityPlayer placer, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            IBlockState state;
            IBlockState state2;
            ItemBlock item;
            Block place_block;
            Item place_item = stack.func_77973_b();
            Block block = place_block = place_item instanceof IPlantable ? ((IPlantable)place_item).getPlant((IBlockAccess)world, pos).func_177230_c() : Block.func_149634_a((Item)place_item);
            if ((place_block == Blocks.field_150350_a || place_block == null) && place_item instanceof ItemBlockSpecial && ((ItemBlockSpecial)place_item).getBlock() != null) {
                place_block = ((ItemBlockSpecial)place_item).getBlock();
            }
            if (place_block == null || place_block == Blocks.field_150350_a) {
                return false;
            }
            Block block2 = world.func_180495_p(pos).func_177230_c();
            if (!block2.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(facing);
            }
            if (!world.func_190527_a(place_block, pos, true, facing, (Entity)null)) {
                return false;
            }
            if (place_item instanceof ItemBlock) {
                item = (ItemBlock)place_item;
                int meta = item.func_77647_b(stack.func_77960_j());
                IBlockState state3 = item.func_179223_d().getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)placer, hand);
                if (!item.placeBlockAt(stack, placer, world, pos, facing, hitX, hitY, hitZ, state3)) {
                    return false;
                }
            } else if (place_item instanceof IPlantable ? !world.func_180501_a(pos, state2 = (item = (IPlantable)place_item).getPlant((IBlockAccess)world, pos), 3) : !world.func_180501_a(pos, state = place_block.func_176223_P(), 3)) {
                return false;
            }
            IBlockState soundstate = world.func_180495_p(pos);
            SoundType stype = soundstate.func_177230_c().getSoundType(soundstate, world, pos, (Entity)placer);
            world.func_184133_a(placer, pos, stype.func_185841_e(), SoundCategory.BLOCKS, (stype.func_185843_a() + 1.0f) / 8.0f, stype.func_185847_b() * 1.1f);
            return true;
        }

        private boolean try_plant(BlockPos pos, EnumFacing facing, ItemStack stack, Block plant_block) {
            IBlockState soilstate;
            IBlockState st;
            Block block;
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock || item instanceof IPlantable || plant_block instanceof IPlantable)) {
                return this.spit_out(facing);
            }
            Block block2 = plant_block instanceof IPlantable ? plant_block : (block = item instanceof IPlantable ? ((IPlantable)item).getPlant((IBlockAccess)this.field_145850_b, pos).func_177230_c() : Block.func_149634_a((Item)item));
            if (item instanceof IPlantable && (st = ((IPlantable)item).getPlant((IBlockAccess)this.field_145850_b, pos)) != null) {
                block = st.func_177230_c();
            }
            if (this.field_145850_b.func_175623_d(pos)) {
                soilstate = this.field_145850_b.func_180495_p(pos.func_177977_b());
                if (block instanceof IPlantable && !soilstate.func_177230_c().canSustainPlant(soilstate, (IBlockAccess)this.field_145850_b, pos.func_177977_b(), EnumFacing.UP, (IPlantable)block)) {
                    return false;
                }
            } else {
                soilstate = this.field_145850_b.func_180495_p(pos);
                if (soilstate.func_177230_c() == block) {
                    return false;
                }
                if (!this.field_145850_b.func_175623_d(pos.func_177984_a())) {
                    return false;
                }
                if (block instanceof IPlantable && !soilstate.func_177230_c().canSustainPlant(soilstate, (IBlockAccess)this.field_145850_b, pos, EnumFacing.UP, (IPlantable)block)) {
                    return false;
                }
                pos = pos.func_177984_a();
            }
            try {
                FakePlayer placer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b));
                if (placer == null || !BTileEntity.place_item(stack, (EntityPlayer)placer, this.field_145850_b, pos, EnumHand.MAIN_HAND, EnumFacing.DOWN, 0.5f, 0.0f, 0.5f)) {
                    return this.spit_out(facing);
                }
                stack.func_190918_g(1);
                this.stacks_.set(this.current_slot_index_, (Object)stack);
                return true;
            }
            catch (Throwable e) {
                ModEngineersDecor.logger.error("Exception while trying to plant " + e);
                this.field_145850_b.func_175698_g(pos);
                return this.spit_out(facing);
            }
        }

        private boolean try_place(EnumFacing facing) {
            if (this.field_145850_b.field_72995_K) {
                return false;
            }
            BlockPos placement_pos = this.field_174879_c.func_177972_a(facing);
            if (this.field_145850_b.func_175625_s(placement_pos) != null) {
                return false;
            }
            ItemStack current_stack = ItemStack.field_190927_a;
            for (int i = 0; i < 18; ++i) {
                if (this.current_slot_index_ >= 18) {
                    this.current_slot_index_ = 0;
                }
                if (!(current_stack = (ItemStack)this.stacks_.get(this.current_slot_index_)).func_190926_b()) break;
                this.current_slot_index_ = BTileEntity.next_slot(this.current_slot_index_);
            }
            if (current_stack.func_190926_b()) {
                this.current_slot_index_ = 0;
                return false;
            }
            Item item = current_stack.func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            if ((block == Blocks.field_150350_a || block == null) && item instanceof ItemBlockSpecial && ((ItemBlockSpecial)item).getBlock() != null) {
                block = ((ItemBlockSpecial)item).getBlock();
            }
            if (item == null) {
                return false;
            }
            if (item instanceof IPlantable || block instanceof IPlantable) {
                return this.try_plant(placement_pos, facing, current_stack, block);
            }
            if (block == Blocks.field_150350_a) {
                try {
                    for (Map.Entry<ItemStack, SpecialPlacementFunction> e : special_placement_conversions.entrySet()) {
                        if (!e.getKey().func_77969_a(current_stack)) continue;
                        ItemStack placement_stack = current_stack.func_77946_l();
                        placement_stack.func_190920_e(1);
                        switch (e.getValue().apply(current_stack, this.field_145850_b, placement_pos)) {
                            case PASS: {
                                return false;
                            }
                            case SUCCESS: {
                                current_stack.func_190918_g(1);
                                this.stacks_.set(this.current_slot_index_, (Object)current_stack);
                                return true;
                            }
                        }
                        return false;
                    }
                }
                catch (Throwable e) {
                    ModEngineersDecor.logger.error("Exception while trying to place " + e);
                    this.field_145850_b.func_175698_g(placement_pos);
                }
                return this.spit_out(facing);
            }
            if (this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(placement_pos), Entity::func_70067_L).size() > 0) {
                return false;
            }
            if (!this.field_145850_b.func_180495_p(placement_pos).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, placement_pos)) {
                return false;
            }
            try {
                FakePlayer placer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b));
                ItemStack placement_stack = current_stack.func_77946_l();
                placement_stack.func_190920_e(1);
                if (placer == null || !BTileEntity.place_item(placement_stack, (EntityPlayer)placer, this.field_145850_b, placement_pos, EnumHand.MAIN_HAND, EnumFacing.DOWN, 0.6f, 0.0f, 0.5f)) {
                    return false;
                }
                current_stack.func_190918_g(1);
                this.stacks_.set(this.current_slot_index_, (Object)current_stack);
            }
            catch (Throwable e) {
                ModEngineersDecor.logger.error("Exception while trying to place " + e);
                this.field_145850_b.func_175698_g(placement_pos);
                return this.spit_out(facing);
            }
            return true;
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 40;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorPlacer)) {
                this.block_power_signal_ = false;
                return;
            }
            boolean dirty = this.block_power_updated_;
            boolean rssignal = (this.logic_ & 1) != 0 == !this.block_power_signal_;
            boolean trigger = rssignal && (this.block_power_updated_ || (this.logic_ & 2) != 0);
            EnumFacing placer_facing = (EnumFacing)state.func_177229_b((IProperty)BlockDecorDirected.FACING);
            boolean tr = this.field_145850_b.func_175640_z(this.field_174879_c);
            this.block_power_updated_ = this.block_power_signal_ != tr;
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if (trigger) {
                if (this.try_place(placer_facing)) {
                    dirty = true;
                } else {
                    this.current_slot_index_ = BTileEntity.next_slot(this.current_slot_index_);
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
            if (trigger && this.tick_timer_ > 40) {
                this.tick_timer_ = 40;
            }
        }

        static {
            for (int i = 0; i < 18; ++i) {
                BTileEntity.SIDED_INV_SLOTS[i] = i;
            }
        }

        @FunctionalInterface
        private static interface SpecialPlacementFunction {
            public EnumActionResult apply(ItemStack var1, World var2, BlockPos var3);
        }
    }

    public static class BContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 18;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        private int[] fields_ = new int[3];

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            int x;
            int y;
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            int i = -1;
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 11 + x * 18;
                    int ypos = 9 + y * 17;
                    this.func_75146_a(new Slot((IInventory)te, ++i, xpos, ypos));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x2, 9 + x2 * 18, 129));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 9 + x * 18, 71 + y * 18));
                }
            }
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void func_75132_a(IContainerListener listener) {
            super.func_75132_a(listener);
            listener.func_175173_a((Container)this, (IInventory)this.te);
        }

        public void func_75142_b() {
            super.func_75142_b();
            for (int il = 0; il < this.field_75149_d.size(); ++il) {
                IContainerListener lis = (IContainerListener)this.field_75149_d.get(il);
                for (int k = 0; k < this.fields_.length; ++k) {
                    int f = this.te.func_174887_a_(k);
                    if (this.fields_[k] == f) continue;
                    this.fields_[k] = f;
                    lis.func_71112_a((Container)this, k, f);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_75137_b(int id, int value) {
            if (id < 0 || id >= this.fields_.length) {
                return;
            }
            this.fields_[id] = value;
            this.te.func_174885_b(id, value);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorPlacer && player.func_174818_b(this.pos) <= 64.0;
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 18) {
                if (!this.func_75135_a(slot_stack, 18, 54, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 18 && index <= 54) {
                if (!this.func_75135_a(slot_stack, 0, 18, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class BGui
    extends GuiContainer {
        private final BTileEntity te;

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            BContainer container = (BContainer)this.field_147002_h;
            if (container.fields_.length != 3) {
                return;
            }
            int mx = mouseX - this.getGuiLeft();
            int my = mouseY - this.getGuiTop();
            if (!this.func_146978_c(126, 1, 49, 60, mouseX, mouseY)) {
                return;
            }
            if (this.func_146978_c(133, 49, 9, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("manual_trigger", 1);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(145, 49, 9, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("logic", container.fields_[0] ^ 1);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(159, 49, 7, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("logic", container.fields_[0] ^ 2);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            }
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/factory_placer_gui.png"));
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.func_73729_b(x0, y0, 0, 0, w, h);
            BContainer container = (BContainer)this.field_147002_h;
            if (container.fields_.length != 3) {
                return;
            }
            int slot_index = container.fields_[2];
            if (slot_index < 0 || slot_index >= 18) {
                slot_index = 0;
            }
            int x = x0 + 10 + slot_index % 6 * 18;
            int y = y0 + 8 + slot_index / 6 * 17;
            this.func_73729_b(x, y, 200, 8, 18, 18);
            if (container.fields_[1] != 0) {
                this.func_73729_b(x0 + 133, y0 + 49, 217, 49, 9, 9);
            }
            int inverter_offset = (container.fields_[0] & 1) != 0 ? 11 : 0;
            this.func_73729_b(x0 + 145, y0 + 49, 177 + inverter_offset, 49, 9, 9);
            int pulse_mode_offset = (container.fields_[0] & 2) != 0 ? 9 : 0;
            this.func_73729_b(x0 + 159, y0 + 49, 199 + pulse_mode_offset, 49, 9, 9);
        }
    }
}

